/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.cardlet.CardConnectionCardlet;
import de.intarsys.security.smartcard.cardlet.CommonCardletFactory;
import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.provider.ProviderTools;
import de.intarsys.tools.string.StringTools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CardletPanel
extends CardDetailPanel {
    private static List<CommonCardletFactory> factories = CardletPanel.findCardletFactories();
    private JComboBox cCardlets;
    private JButton cButton;
    private JTextArea cText;

    protected static List<CommonCardletFactory> findCardletFactories() {
        ArrayList<CommonCardletFactory> factories = new ArrayList<CommonCardletFactory>();
        Iterator iterator = ProviderTools.providers(CommonCardletFactory.class);
        while (iterator.hasNext()) {
            CommonCardletFactory candidate = (CommonCardletFactory)iterator.next();
            factories.add(candidate);
        }
        return factories;
    }

    public CardletPanel() {
        this.init();
    }

    protected CardConnectionCardlet createCardlet() {
        CommonCardletFactory factory = (CommonCardletFactory)this.cCardlets.getSelectedItem();
        try {
            if (factory == null) {
                this.cText.setText("select a factory first");
                return null;
            }
            IFunctor functor = factory.createFunctor(new Object[0]);
            if (!(functor instanceof CardConnectionCardlet)) {
                this.cText.setText("cardlet " + functor + " not usable");
                return null;
            }
            CardConnectionCardlet result = (CardConnectionCardlet)functor;
            result.setCardConnection(this.getCardConnection());
            return result;
        }
        catch (Exception e) {
            this.cText.setText(ExceptionTools.getStackTraceString((Throwable)e));
            return null;
        }
    }

    protected void doCardletRun() {
        try {
            CardConnectionCardlet cardlet = this.createCardlet();
            if (cardlet == null) {
                this.cText.setText("no cardlet");
                return;
            }
            this.cText.setText("");
            Object result = cardlet.perform((IFunctorCall)new FunctorCall((Object)this, (IArgs)Args.create()));
            this.cText.setText(StringTools.safeString(result));
        }
        catch (Exception e) {
            this.cText.setText(ExceptionTools.getStackTraceString((Throwable)e));
        }
    }

    @Override
    public void eventShow() {
        super.eventShow();
        if (this.getCardConnection() == null) {
            this.cText.setText("no connection");
        } else {
            this.cText.setText("");
        }
        this.cButton.setEnabled(this.getCardConnection() != null);
    }

    @Override
    public String getLabel() {
        return "Cardlet launcher";
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.cCardlets = new JComboBox();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(factories.toArray());
        this.cCardlets.setModel(model);
        this.cCardlets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardletPanel.this.onSelection();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.cCardlets, gbc);
        this.cButton = new JButton();
        this.cButton.setText("Run...");
        this.cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardletPanel.this.doCardletRun();
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.cButton, gbc);
        this.cText = new JTextArea();
        JScrollPane cScroller = new JScrollPane(this.cText);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)cScroller, gbc);
    }

    protected void onSelection() {
        String msg = "";
        msg = "select a factory";
        CommonCardletFactory factory = (CommonCardletFactory)this.cCardlets.getSelectedItem();
        if (factory instanceof IPresentationSupport) {
            msg = factory.getDescription();
        }
        this.cText.setText(msg);
    }
}

