/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.explorer.CardExplorer;
import de.intarsys.security.smartcard.explorer.CardExplorerNode;
import de.intarsys.security.smartcard.explorer.CardExplorerPanelNode;
import de.intarsys.security.smartcard.explorer.TextPanel;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;

public class ISO7816CiaNode
extends CardExplorerNode {
    private final CardFileSelector file;

    public ISO7816CiaNode(CardExplorer explorer, ICardConnection cardConnection, CardFileSelector file) {
        super(explorer, cardConnection);
        this.setLabel("CIA " + file.toString());
        this.file = file;
    }

    @Override
    protected void basicCreateChildren() {
        super.basicCreateChildren();
        try {
            Pkcs15Structure pkcs15 = Pkcs15Structure.getPkcs15(this.getCardProduct(), this.getCardConnection(), this.getFile(), null);
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("TokenInfo", pkcs15.getP15TokenInfo().toString())));
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("ODF", pkcs15.getP15ObjectDirectoryFile().toString())));
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("Certificate", pkcs15.getP15CertificateObjectDirectory().toString())));
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("Authentication", pkcs15.getP15AuthenticationObjectDirectory().toString())));
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("PrivateKey", pkcs15.getP15PrivateKeyObjectDirectory().toString())));
            this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new TextPanel("PublicKey", pkcs15.getP15PublicKeyObjectDirectory().toString())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected CardFileSelector getFile() {
        return this.file;
    }
}

