/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.iso.dataobject.EFAtr;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.awt.BorderLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ISO7816EfAtrPanel
extends CardDetailPanel {
    private JTextArea cText;

    public ISO7816EfAtrPanel() {
        this.init();
    }

    @Override
    public void eventShow() {
        super.eventShow();
        String text = this.getText();
        this.cText.setText(text);
    }

    @Override
    public String getLabel() {
        return "EF.Atr";
    }

    protected String getText() {
        try {
            if (this.getCardConnection() == null) {
                return "no connection";
            }
            ICardProduct product = this.getCardProduct();
            if (product == null) {
                return "no product";
            }
            IFileSystemApplication fs = product.createCardApplication(this.getCardConnection(), IFileSystemApplication.class);
            fs.selectEf(EFAtr.FILE_PATH, false);
            byte[] bytes = fs.readBinary(EFAtr.FILE_PATH);
            TlvTemplate template = Iso7816BerElement.parseTemplate(bytes, 0, bytes.length);
            EFAtr file = new EFAtr(template);
            return file.toString();
        }
        catch (CardFileNotFoundException e) {
            return "no EF.Atr";
        }
        catch (Exception e) {
            return "error reading EF.Atr (" + ExceptionTools.getMessage((Throwable)e) + ")";
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.cText = new JTextArea();
        JScrollPane cScroller = new JScrollPane(this.cText);
        this.add(cScroller);
    }
}

