/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.iso.dataobject.EFDir;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.tools.exception.ExceptionTools;
import java.awt.BorderLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ISO7816EfDirPanel
extends CardDetailPanel {
    private JTextArea cText;

    public ISO7816EfDirPanel() {
        this.init();
    }

    @Override
    public void eventShow() {
        super.eventShow();
        String text = this.getText();
        this.cText.setText(text);
    }

    @Override
    public String getLabel() {
        return "EF.Dir";
    }

    protected String getText() {
        try {
            if (this.getCardConnection() == null) {
                return "no connection";
            }
            ICardProduct product = this.getCardProduct();
            if (product == null) {
                return "no product";
            }
            IFileSystemApplication fs = product.createCardApplication(this.getCardConnection(), IFileSystemApplication.class);
            EFDir efDir = EFDir.create(fs);
            return efDir.toString();
        }
        catch (CardFileNotFoundException e) {
            return "no EF.Dir";
        }
        catch (Exception e) {
            return "error reading EF.Dir (" + ExceptionTools.getMessage((Throwable)e) + ")";
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.cText = new JTextArea();
        JScrollPane cScroller = new JScrollPane(this.cText);
        this.add(cScroller);
    }
}

