/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.explorer.CardExplorer;
import de.intarsys.security.smartcard.explorer.CardExplorerNode;
import de.intarsys.security.smartcard.explorer.CardExplorerPanelNode;
import de.intarsys.security.smartcard.explorer.ISO7816AtrPanel;
import de.intarsys.security.smartcard.explorer.ISO7816CiaNode;
import de.intarsys.security.smartcard.explorer.ISO7816EfAtrPanel;
import de.intarsys.security.smartcard.explorer.ISO7816EfDirPanel;
import de.intarsys.security.smartcard.iso.dataobject.ApplicationTemplate;
import de.intarsys.security.smartcard.iso.dataobject.EFDir;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public class ISO7816Node
extends CardExplorerNode {
    public ISO7816Node(CardExplorer explorer, ICardConnection cardConnection) {
        super(explorer, cardConnection);
        this.setLabel("ISO7816");
    }

    @Override
    protected void basicCreateChildren() {
        super.basicCreateChildren();
        this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new ISO7816AtrPanel()));
        this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new ISO7816EfDirPanel()));
        this.add(new CardExplorerPanelNode(this.getExplorer(), this.getCardConnection(), new ISO7816EfAtrPanel()));
        try {
            Iterator<ApplicationTemplate> it = this.getApplicationTemplates();
            while (it.hasNext()) {
                ApplicationTemplate at = it.next();
                if (!at.getApplicationIdentifier().isIsoCia()) continue;
                this.add(new ISO7816CiaNode(this.getExplorer(), this.getCardConnection(), at.getApplicationIdentifier().asCardFile()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add(new ISO7816CiaNode(this.getExplorer(), this.getCardConnection(), Pkcs15Structure.PKCS15_AID));
    }

    protected Iterator<ApplicationTemplate> getApplicationTemplates() throws CardApplicationException, IOException {
        if (this.getCardConnection() == null) {
            return Collections.emptyIterator();
        }
        ICardProduct product = this.getCardProduct();
        if (product == null) {
            return Collections.emptyIterator();
        }
        IFileSystemApplication fs = product.createCardApplication(this.getCardConnection(), IFileSystemApplication.class);
        EFDir efDir = EFDir.create(fs);
        return efDir.getApplicationTemplates();
    }
}

