/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.tools.collection.ByteArrayTools;

public class ISOCmdChangeReferenceData
extends AbstractCmd
implements ICmdChangeReferenceData {
    private boolean explicitModeSupported = true;

    @Override
    public RequestAPDU create(int pinRef, byte[] newPin) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 36, 1, pinRef, newPin, false);
        request.setLabel(this.getLabel() + ", verified explicit, pin " + pinRef);
        request.setSensitiveContent(true);
        return request;
    }

    @Override
    public RequestAPDU create(int pinRef, byte[] pin, byte[] newPin) {
        byte[] concat = ByteArrayTools.concat((byte[][])new byte[][]{pin, newPin});
        RequestAPDU request = new RequestAPDU(this.getCla(), 36, 0, pinRef, concat, false);
        request.setLabel(this.getLabel() + ", verified implicit, pin " + pinRef);
        request.setSensitiveContent(true);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdChangeReferenceData.class;
    }

    @Override
    public int getIns() {
        return 36;
    }

    @Override
    public String getLabel() {
        return "change reference data";
    }

    @Override
    public boolean isExplicitModeSupported() {
        return this.explicitModeSupported;
    }

    public void setExplicitModeSupported(boolean explicitModeSupported) {
        this.explicitModeSupported = explicitModeSupported;
    }
}

