/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.iso.dataobject.AccessConditions;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleElement;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdCreate;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;

public class ISOCmdCreate
extends AbstractCmd
implements ICmdCreate {
    @Override
    public RequestAPDU createCreateDirectory(CardFileId file, boolean shared) {
        TlvTemplate template = new TlvTemplate();
        template.addElement((TlvElement)new Iso7816SimpleElement(129, new byte[]{8, 0}));
        int fd = 56;
        if (shared) {
            fd |= 0x40;
        }
        template.addElement((TlvElement)new Iso7816SimpleElement(130, new byte[]{(byte)fd}));
        template.addElement((TlvElement)new Iso7816SimpleElement(131, file.getBytes()));
        template.addElement((TlvElement)new Iso7816SimpleElement(133, new byte[]{0}));
        template.addElement((TlvElement)new Iso7816SimpleElement(134, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Iso7816SimpleElement elFcp = new Iso7816SimpleElement(98, template.getEncoded());
        RequestAPDU request = new RequestAPDU(this.getCla(), 224, 0, 0, elFcp.getEncoded(), false);
        request.setLabel(this.getLabel() + " directory " + file);
        return request;
    }

    @Override
    public RequestAPDU createCreateFileTransparent(CardFileId file, boolean shared, int size, AccessConditions accessConditions) {
        TlvTemplate template = new TlvTemplate();
        int high = (size & 0xFF00) >> 8;
        int low = size & 0xFF;
        template.addElement((TlvElement)new Iso7816SimpleElement(128, new byte[]{(byte)high, (byte)low}));
        int fd = 1;
        if (shared) {
            fd |= 0x40;
        }
        template.addElement((TlvElement)new Iso7816SimpleElement(130, new byte[]{(byte)fd}));
        template.addElement((TlvElement)new Iso7816SimpleElement(131, file.getBytes()));
        if (accessConditions != null) {
            template.addElement(accessConditions.getElement());
        }
        Iso7816SimpleElement elFcp = new Iso7816SimpleElement(98, template.getEncoded());
        RequestAPDU request = new RequestAPDU(this.getCla(), 224, 0, 0, elFcp.getEncoded(), false);
        request.setLabel(this.getLabel() + " transparent file " + file);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdCreate.class;
    }

    @Override
    public int getIns() {
        return 224;
    }

    @Override
    public String getLabel() {
        return "create";
    }
}

