/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.iso.dataobject.CrdoTools;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdManageSecurityEnvironment;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.tlv.common.TlvElement;

public class ISOCmdManageSecurityEnvironment
extends AbstractCmd
implements ICmdManageSecurityEnvironment {
    @Override
    public RequestAPDU createRestore(int securityEnvId) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 34, this.getRestoreCode(), securityEnvId);
        request.setLabel(this.getLabel() + " restore " + securityEnvId);
        return request;
    }

    public RequestAPDU createSet(boolean extAuthOrVerification, int component, byte[] data) {
        int setCode = this.getSetCode(extAuthOrVerification);
        RequestAPDU request = new RequestAPDU(this.getCla(), 34, setCode, component, data, false);
        request.setLabel(this.getLabel() + " component " + component);
        return request;
    }

    @Override
    public RequestAPDU createSetComponentAlgoRef(int component, int algoRef) {
        TlvElement tlvAlgoRef = CrdoTools.createAlgorithmRef(algoRef);
        return this.createSet(false, component, tlvAlgoRef.getEncoded());
    }

    @Override
    public RequestAPDU createSetComponentKey(int component, byte[] prKeyRef) {
        TlvElement tlvKeyRef = CrdoTools.createKeyRefPrivate(prKeyRef);
        return this.createSet(false, component, tlvKeyRef.getEncoded());
    }

    @Override
    public RequestAPDU createSetComponentKeyAlgo(int component, byte[] prKey, byte[] algorithm) {
        TlvElement tlvKeyRef = CrdoTools.createKeyRefPrivate(prKey);
        TlvElement tlvAlgoId = CrdoTools.createAlgorithmId(algorithm);
        return this.createSet(false, component, ByteArrayTools.concat((byte[][])new byte[][]{tlvKeyRef.getEncoded(), tlvAlgoId.getEncoded()}));
    }

    @Override
    public RequestAPDU createSetComponentKeyAlgoRef(int component, byte[] prKeyRef, int algoRef) {
        TlvElement tlvKeyRef = CrdoTools.createKeyRefPrivate(prKeyRef);
        TlvElement tlvAlgoRef = CrdoTools.createAlgorithmRef(algoRef);
        return this.createSet(false, component, ByteArrayTools.concat((byte[][])new byte[][]{tlvKeyRef.getEncoded(), tlvAlgoRef.getEncoded()}));
    }

    @Override
    public Class getCommandType() {
        return ICmdManageSecurityEnvironment.class;
    }

    @Override
    public int getIns() {
        return 34;
    }

    @Override
    public String getLabel() {
        return "manage security environment";
    }

    protected int getRestoreCode() {
        return 243;
    }

    public int getSetCode(boolean extAuthOrVerification) {
        int mode = 1;
        mode = extAuthOrVerification ? (mode |= 0x80) : (mode |= 0x40);
        return mode;
    }
}

