/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdPerformSecurityOperation;

public class ISOCmdPerformSecurityOperation
extends AbstractCmd
implements ICmdPerformSecurityOperation {
    @Override
    public RequestAPDU createComputeDigitalSignature(byte[] message) {
        return this.createComputeDigitalSignature(message, 0);
    }

    @Override
    public RequestAPDU createComputeDigitalSignature(byte[] message, int keyByteSize) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 42, 158, 154, message, keyByteSize, false);
        request.setLabel(this.getLabel() + " compute digital signature");
        return request;
    }

    @Override
    public RequestAPDU createDecipher(byte[] cryptogram, int paddingIndicator, int keyByteSize) {
        byte[] data = this.decipherAddPaddingIndicator(cryptogram, 0, cryptogram.length, paddingIndicator);
        RequestAPDU request = new RequestAPDU(this.getCla(), 42, 128, 134, data, keyByteSize, false);
        request.setLabel(this.getLabel() + " decipher");
        return request;
    }

    @Override
    public RequestAPDU createHashUpload(byte[] digest) {
        byte[] data = new byte[digest.length + 2];
        data[0] = -112;
        data[1] = (byte)digest.length;
        System.arraycopy(digest, 0, data, 2, digest.length);
        RequestAPDU request = new RequestAPDU(this.getCla(), 42, 144, 160, data, false);
        request.setLabel(this.getLabel() + " upload hash");
        return request;
    }

    @Override
    public RequestAPDU createVerifyCertificate(byte[] data) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 42, 0, 190, data, false);
        request.setLabel(this.getLabel() + " verify certificate");
        return request;
    }

    protected byte[] decipherAddPaddingIndicator(byte[] cryptogram, int offset, int length, int paddingIndicator) {
        byte[] data = new byte[length + 1];
        data[0] = (byte)paddingIndicator;
        System.arraycopy(cryptogram, offset, data, 1, length);
        return data;
    }

    @Override
    public Class getCommandType() {
        return ICmdPerformSecurityOperation.class;
    }

    @Override
    public int getIns() {
        return 42;
    }

    @Override
    public String getLabel() {
        return "perform security operation";
    }
}

