/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.OperationNotSupported;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdReadBinary;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.tlv.common.TlvElement;

public class ISOCmdReadBinary
extends AbstractCmd
implements ICmdReadBinary {
    private boolean selectFile = false;

    @Override
    public RequestAPDU create(CardFileId fileId, int offset, int length) throws OperationNotSupported {
        RequestAPDU request;
        if (this.isSelectFile()) {
            byte[] data = new byte[]{84, 2, (byte)(offset >> 8 & 0xFF), (byte)(offset & 0xFF)};
            if (fileId != null) {
                if (fileId.isShort()) {
                    int p1 = 0;
                    byte p2 = fileId.getShortId();
                    request = new RequestAPDU(this.getCla(), 177, p1, (int)p2, data, length, false);
                } else {
                    byte p1 = fileId.getHiByte();
                    byte p2 = fileId.getLowByte();
                    request = new RequestAPDU(this.getCla(), 177, (int)p1, (int)p2, data, length, false);
                }
                request.setLabel(this.getLabel() + ", file " + fileId + ", offset " + offset + ", length " + length);
            } else {
                int p1 = 0;
                int p2 = 0;
                request = new RequestAPDU(this.getCla(), 177, p1, p2, data, length, false);
                request.setLabel(this.getLabel() + ", offset " + offset + ", length " + length);
            }
        } else if (fileId != null && fileId.isShort() && offset == 0) {
            byte p22 = fileId.getShortId();
            request = this.create(p22, offset, length);
        } else {
            request = this.create(offset, length);
        }
        return request;
    }

    @Override
    public RequestAPDU create(int offset, int length) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 176, this.getP1Plain(offset), this.getP2Plain(offset), length, false);
        request.setLabel(this.getLabel() + " current, offset " + offset + ", length " + length);
        return request;
    }

    @Override
    public RequestAPDU create(int id, int offset, int length) throws OperationNotSupported {
        int p1 = this.getP1Short(id, offset);
        int p2 = this.getP2Short(id, offset);
        RequestAPDU request = new RequestAPDU(this.getCla(), 176, p1, p2, length, false);
        request.setLabel(this.getLabel() + ", short id " + id + ", offset " + offset + ", length " + length);
        return request;
    }

    protected TlvElement createOffset(int offset) {
        return new Iso7816BerElement(84, ByteArrayTools.toBytesBigEndian((int)offset));
    }

    @Override
    public Class getCommandType() {
        return ICmdReadBinary.class;
    }

    @Override
    public int getIns() {
        return 176;
    }

    @Override
    public String getLabel() {
        return "read binary";
    }

    protected int getP1Ext(int id, int offset) {
        return 0;
    }

    protected int getP1Plain(int offset) {
        return offset >> 8 & 0x7F;
    }

    protected int getP1Short(int id, int offset) {
        return id | 0x80;
    }

    protected int getP2Ext(int id, int offset) {
        return id;
    }

    protected int getP2Plain(int offset) {
        return offset & 0xFF;
    }

    protected int getP2Short(int id, int offset) throws OperationNotSupported {
        if (offset > 255) {
            throw new OperationNotSupported("offset too large");
        }
        return offset;
    }

    public boolean isSelectFile() {
        return this.selectFile;
    }

    public void setSelectFile(boolean selectFile) {
        this.selectFile = selectFile;
    }
}

