/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdReadRecord;

public class ISOCmdReadRecord
extends AbstractCmd
implements ICmdReadRecord {
    public RequestAPDU create(byte shortId, int index, int size) {
        int p1 = this.getP1Short(index);
        int p2 = this.getP2Short(shortId);
        RequestAPDU request = new RequestAPDU(this.getCla(), 178, p1, p2, size < 0 ? 0 : size, false);
        request.setLabel(this.getLabel() + ", file id " + shortId + ", index " + index + ", size " + size);
        return request;
    }

    @Override
    public RequestAPDU create(CardFileId fileId, int index, int size) {
        RequestAPDU req = fileId != null && fileId.isShort() ? this.create(fileId.getShortId(), index, size) : this.create(index, size);
        return req;
    }

    @Override
    public RequestAPDU create(int index, int size) {
        int p1 = this.getP1Plain(index);
        int p2 = this.getP2Plain();
        RequestAPDU request = new RequestAPDU(this.getCla(), 178, p1, p2, size < 0 ? 0 : size, false);
        request.setLabel(this.getLabel() + " current, index " + index + ", size " + size);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdReadRecord.class;
    }

    @Override
    public int getIns() {
        return 178;
    }

    @Override
    public String getLabel() {
        return "read record";
    }

    protected int getP1Plain(int index) {
        return index;
    }

    protected int getP1Short(int index) {
        return index;
    }

    protected int getP2Plain() {
        return 4;
    }

    protected int getP2Short(int id) {
        return id << 3 | 4;
    }
}

