/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdResetRetryCounter;
import de.intarsys.tools.collection.ByteArrayTools;

public class ISOCmdResetRetryCounter
extends AbstractCmd
implements ICmdResetRetryCounter {
    @Override
    public RequestAPDU create(int pinRef) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 44, 3, pinRef);
        request.setLabel(this.getLabel() + ", verify explicit, reset only, pin " + pinRef);
        return request;
    }

    @Override
    public RequestAPDU create(int pinRef, byte[] resetCode, byte[] newData) {
        byte[] concat = ByteArrayTools.concat((byte[][])new byte[][]{resetCode, newData});
        RequestAPDU request = new RequestAPDU(this.getCla(), 44, 0, pinRef, concat, false);
        request.setLabel(this.getLabel() + ", verify implicit, reset to new, pin " + pinRef);
        request.setSensitiveContent(true);
        return request;
    }

    @Override
    public RequestAPDU createWithNewReferenceData(int pinRef, byte[] newData) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 44, 2, pinRef, newData, false);
        request.setLabel(this.getLabel() + ", verify explicit, reset to new, pin " + pinRef);
        request.setSensitiveContent(true);
        return request;
    }

    @Override
    public RequestAPDU createWithResettingCode(int pinRef, byte[] resetData) {
        RequestAPDU request = new RequestAPDU(this.getCla(), 44, 1, pinRef, resetData, false);
        request.setLabel(this.getLabel() + ", verify implicit, reset only, pin " + pinRef);
        request.setSensitiveContent(true);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdResetRetryCounter.class;
    }

    @Override
    public int getIns() {
        return 44;
    }

    @Override
    public String getLabel() {
        return "reset retry counter";
    }
}

