/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.FCPbasedFileInfo;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.dataobject.FCP;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdSelect;
import java.io.IOException;

public class ISOCmdSelect
extends AbstractCmd
implements ICmdSelect {
    private int defaultResultType = 4;
    private boolean supportSelectParent = true;
    private boolean selectUsingAny = false;

    @Override
    public CardFileInfo createCardFileInfo(ResponseAPDU response) throws CardApplicationException {
        try {
            FCP fcp = this.getFCP(response);
            if (fcp == null) {
                return null;
            }
            return new FCPbasedFileInfo(fcp);
        }
        catch (Exception e) {
            Log.warn("failed to create FCP for {}" + response);
            return null;
        }
    }

    @Override
    public RequestAPDU createSelectAny(CardFileId file) {
        return this.createSelectAny(file, this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectAny(CardFileId file, int resultType) {
        int le = this.getLE(resultType);
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, 0, resultType, file.getBytes(), le, false);
        request.setLabel(this.getLabel() + " file " + file);
        return request;
    }

    @Override
    public RequestAPDU createSelectChildDf(CardFileId subDir) {
        return this.createSelectChildDf(subDir, this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectChildDf(CardFileId subDir, int resultType) {
        int p1 = this.isSelectUsingAny() ? 0 : 1;
        int le = this.getLE(resultType);
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, p1, resultType, subDir.getBytes(), le, false);
        request.setLabel(this.getLabel() + " child DF " + subDir);
        return request;
    }

    @Override
    public RequestAPDU createSelectChildEf(CardFileId file) {
        return this.createSelectChildEf(file, this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectChildEf(CardFileId file, int resultType) {
        int p1 = this.isSelectUsingAny() ? 0 : 2;
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, p1, resultType, file.getBytes(), this.getLE(resultType), false);
        request.setLabel(this.getLabel() + " child EF " + file);
        return request;
    }

    @Override
    public RequestAPDU createSelectDfName(CardFileName appId) {
        return this.createSelectDfName(appId, this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectDfName(CardFileName appId, int resultType) {
        int le = this.getLE(resultType);
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, 4, resultType, appId.getBytes(), le, false);
        request.setLabel(this.getLabel() + " DF " + appId);
        return request;
    }

    @Override
    public RequestAPDU createSelectMf() {
        return this.createSelectMf(this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectMf(int resultType) {
        int le = this.getLE(resultType);
        byte[] data = CardFileId.MF.getBytes();
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, 0, resultType, data, le, false);
        request.setLabel(this.getLabel() + " MF");
        return request;
    }

    @Override
    public RequestAPDU createSelectParent() {
        if (!this.isSupportSelectParent()) {
            return null;
        }
        return this.createSelectParent(this.getDefaultResultType());
    }

    @Override
    public RequestAPDU createSelectParent(int resultType) {
        if (!this.isSupportSelectParent()) {
            return null;
        }
        RequestAPDU request = new RequestAPDU(this.getCla(), 164, 3, resultType, this.getLE(resultType), false);
        request.setLabel(this.getLabel() + " parent");
        return request;
    }

    @Override
    public Class<ICmdSelect> getCommandType() {
        return ICmdSelect.class;
    }

    public int getDefaultResultType() {
        return this.defaultResultType;
    }

    @Override
    public FCP getFCP(ResponseAPDU response) throws CardApplicationException {
        byte[] result = response.getData();
        if (result == null || result.length == 0) {
            return null;
        }
        try {
            Iso7816BerElement element = Iso7816BerElement.parseElement(result, 0, result.length);
            if (element == null) {
                return null;
            }
            if (element.getIdentifier() == 98) {
                return new FCP(element);
            }
            return null;
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
    }

    @Override
    public int getIns() {
        return 164;
    }

    @Override
    public String getLabel() {
        return "select";
    }

    public int getLE(int resultType) {
        if (resultType == 12) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getResultType(boolean readFileInfo) {
        return readFileInfo ? this.getDefaultResultType() : 12;
    }

    public boolean isSelectUsingAny() {
        return this.selectUsingAny;
    }

    public boolean isSupportSelectParent() {
        return this.supportSelectParent;
    }

    public void setDefaultResultType(int defaultResultType) {
        this.defaultResultType = defaultResultType;
    }

    public void setSelectUsingAny(boolean selectUsingAny) {
        this.selectUsingAny = selectUsingAny;
    }

    public void setSupportSelectParent(boolean supportSelectParent) {
        this.supportSelectParent = supportSelectParent;
    }
}

