/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdUpdateBinary;

public class ISOCmdUpdateBinary
extends AbstractCmd
implements ICmdUpdateBinary {
    public RequestAPDU create(byte shortId, int offset, byte[] data) {
        int p1 = this.getP1Short(shortId, offset);
        int p2 = this.getP2Short(shortId, offset);
        RequestAPDU request = new RequestAPDU(this.getCla(), 214, p1, p2, data, false);
        request.setLabel(this.getLabel() + " short id " + shortId + ", offset " + offset);
        return request;
    }

    @Override
    public RequestAPDU create(CardFileId fileId, int fileOffset, byte[] data) {
        RequestAPDU req = fileId != null && fileId.isShort() ? this.create(fileId.getShortId(), fileOffset, data) : this.create(fileOffset, data);
        return req;
    }

    @Override
    public RequestAPDU create(int offset, byte[] data) {
        int p1 = this.getP1Plain(offset);
        int p2 = this.getP2Plain(offset);
        RequestAPDU request = new RequestAPDU(this.getCla(), 214, p1, p2, data, false);
        request.setLabel(this.getLabel() + " current, offset " + offset);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdUpdateBinary.class;
    }

    @Override
    public int getIns() {
        return 214;
    }

    @Override
    public String getLabel() {
        return "update binary";
    }

    protected int getP1Plain(int offset) {
        return offset >> 8 & 0x7F;
    }

    protected int getP1Short(int id, int offset) {
        return id & 0x80;
    }

    protected int getP2Plain(int offset) {
        return offset & 0xFF;
    }

    protected int getP2Short(int id, int offset) {
        return offset & 0xFF;
    }
}

