/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.cmd;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleElement;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.security.smartcard.model.cmd.ICmdUpdateRecord;

public class ISOCmdUpdateRecord
extends AbstractCmd
implements ICmdUpdateRecord {
    public static final int P2_RecordNumberInP1 = 4;

    protected RequestAPDU create(byte shortId, int index, byte[] data) {
        Iso7816SimpleElement element = new Iso7816SimpleElement(index, data);
        int p1 = this.getP1Short(index);
        int p2 = this.getP2Short(shortId);
        RequestAPDU request = new RequestAPDU(this.getCla(), 220, p1, p2, element.getEncoded(), false);
        request.setLabel(this.getLabel() + " short id " + shortId + ", index " + index);
        return request;
    }

    @Override
    public RequestAPDU create(CardFileId fileId, int index, byte[] data) {
        RequestAPDU req = fileId != null && fileId.isShort() ? this.create(fileId.getShortId(), index, data) : this.create(index, data);
        return req;
    }

    @Override
    public RequestAPDU create(int index, byte[] recordData) {
        Iso7816SimpleElement element = new Iso7816SimpleElement(index, recordData);
        int p1 = this.getP1Plain(index);
        int p2 = this.getP2Plain();
        RequestAPDU request = new RequestAPDU(this.getCla(), 220, p1, p2, element.getEncoded(), false);
        request.setLabel(this.getLabel() + " current, index " + index);
        return request;
    }

    @Override
    public Class getCommandType() {
        return ICmdUpdateRecord.class;
    }

    @Override
    public int getIns() {
        return 220;
    }

    @Override
    public String getLabel() {
        return "update record";
    }

    protected int getP1Plain(int index) {
        return index;
    }

    protected int getP1Short(int index) {
        return index;
    }

    protected int getP2Plain() {
        return 4;
    }

    protected int getP2Short(int id) {
        return id << 3 | 4;
    }
}

