/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.dataobject;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.iso.dataobject.ApplicationTemplate;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tools.tlv.common.TlvTemplateBasedObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class EFDir
extends TlvTemplateBasedObject {
    public static final CardFileSelector FILE_PATH = new CardFilePath("3F00:2F00");
    public static final CardFileSelector FILE_ID = new CardFileId("2F00");

    public static EFDir create(IFileSystemApplication fs) throws CardApplicationException, IOException {
        CardFileInfo info = fs.selectEf(FILE_PATH, true);
        if (info == null) {
            return new EFDir(new TlvTemplate());
        }
        TlvTemplate template = null;
        if (info.isTransparent()) {
            byte[] bytes = fs.readBinary(FILE_PATH);
            template = Iso7816BerElement.parseTemplate(bytes, 0, bytes.length);
        } else {
            byte[][] records = fs.readRecords(FILE_PATH, -1);
            ArrayList<Iso7816BerElement> elements = new ArrayList<Iso7816BerElement>();
            for (byte[] rec : records) {
                elements.add(Iso7816BerElement.parseElement(rec, 0, rec.length));
            }
            template = new TlvTemplate(elements);
        }
        return new EFDir(template);
    }

    public EFDir(TlvTemplate template) {
        super(template);
    }

    public Iterator<ApplicationTemplate> getApplicationTemplates() {
        Iterator it = this.getTemplate().iteratorTagged(97);
        return new ConversionIterator<TlvElement, ApplicationTemplate>(it){

            protected ApplicationTemplate createTargetObject(TlvElement sourceObject) {
                return new ApplicationTemplate(sourceObject.getTemplate());
            }
        };
    }

    protected void toStringMembers(StringBuilder sb, int level) {
        Iterator<ApplicationTemplate> it = this.getApplicationTemplates();
        while (it.hasNext()) {
            this.toStringMember(sb, level, "applicationTemplate", (Object)it.next(), null);
        }
    }
}

