/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.dataobject;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvElementBasedObject;

public class FileDescriptor
extends TlvElementBasedObject {
    public static final int TAG = 130;
    public static final int FLAG_EF = 0;
    public static final int FLAG_DF = 56;
    public static final int FLAG_SHAREABLE = 64;
    public static final int FLAG_LINEAR_FIXED = 2;
    public static final int FLAG_LINEAR_FIXED_TLV = 3;
    public static final int FLAG_LINEAR_VARIABLE = 4;
    public static final int FLAG_LINEAR_VARIABLE_TLV = 5;
    public static final int FLAG_CYCLIC_FIXED = 6;
    public static final int FLAG_CYCLIC_FIXED_TLV = 7;
    public static final int FLAG_TRANSPARENT = 1;
    private static final int TEST_TYPE = 6;
    private static final int TEST_TYPE_LINEARFIXED = 2;
    private static final int TEST_TYPE_LINEARVARIABLE = 4;
    private static final int TEST_TYPE_CYCLICFIXED = 6;

    public FileDescriptor(TlvElement element) {
        super(element);
    }

    public int getMaximumRecordSize() {
        if (this.getElement().getLength() > 2) {
            if (this.getElement().getLength() == 3) {
                return ByteArrayTools.toBigEndianIntUnsigned((byte[])this.getElement().getValue(), (int)2, (int)1);
            }
            return ByteArrayTools.toBigEndianIntUnsigned((byte[])this.getElement().getValue(), (int)2, (int)2);
        }
        return 0;
    }

    public int getNumberOfRecords() {
        if (this.getElement().getLength() > 4) {
            if (this.getElement().getLength() == 5) {
                return ByteArrayTools.toBigEndianIntUnsigned((byte[])this.getElement().getValue(), (int)4, (int)1);
            }
            return ByteArrayTools.toBigEndianIntUnsigned((byte[])this.getElement().getValue(), (int)4, (int)2);
        }
        return 0;
    }

    public boolean isCyclicFixed() {
        if (this.isDirectory()) {
            return false;
        }
        return (this.getFirstByte() & 6) == 6;
    }

    public boolean isDirectory() {
        return (this.getFirstByte() & 0x38) == 56;
    }

    public boolean isLinearFixed() {
        if (this.isDirectory()) {
            return false;
        }
        return (this.getFirstByte() & 6) == 2;
    }

    public boolean isLinearVariable() {
        if (this.isDirectory()) {
            return false;
        }
        return (this.getFirstByte() & 6) == 4;
    }

    public boolean isShareable() {
        return (this.getFirstByte() & 0x40) == 64;
    }

    public boolean isTlv() {
        if (this.isDirectory()) {
            return false;
        }
        return (this.getFirstByte() & 6) != 0 && (this.getFirstByte() & 1) != 0;
    }

    public boolean isTransparent() {
        if (this.isDirectory()) {
            return false;
        }
        return (this.getFirstByte() & 6) == 0 && (this.getFirstByte() & 1) != 0;
    }
}

