/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.dataobject;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvElementBasedObject;

public class FileReference
extends TlvElementBasedObject {
    public static final int TAG = 81;

    public FileReference(TlvElement element) {
        super(element);
    }

    public CardFileName asCardFile() {
        return new CardFileName(this.getBytes());
    }

    public int asInt() {
        return ByteArrayTools.toBigEndianInt((byte[])this.getBytes(), (int)0, (int)this.getLength());
    }

    public CardFileId getFileIdentifier() {
        return new CardFileId(this.getBytes());
    }

    public CardFilePath getFilepath() {
        if (this.isQualified()) {
            return new CardFilePath(ByteArrayTools.copy((byte[])this.getBytes(), (int)0, (int)(this.getLength() - 1)));
        }
        return new CardFilePath(this.getBytes());
    }

    public int getQualifier() {
        if (this.isQualified()) {
            return this.getByteAt(this.getLength() - 1);
        }
        return 0;
    }

    public int getShortIdentifier() {
        byte temp = this.getElement().getValueAt(0);
        return temp >> 3;
    }

    public boolean isFileIdentifier() {
        return this.getLength() == 2;
    }

    public boolean isFilePath() {
        return this.getLength() > 2;
    }

    public boolean isMF() {
        return this.getLength() == 0;
    }

    public boolean isQualified() {
        return this.getLength() % 2 != 0;
    }

    public boolean isShortIdentifier() {
        return this.getLength() == 1 && this.getByteAt(0) != 0 && this.getByteAt(0) != -8;
    }
}

