/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.dataobject;

import de.intarsys.security.smartcard.card.ATR;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.tools.attribute.Attribute;

public class HistoricalBytes {
    private static final Attribute ATTR_HISTORICALBYTES = new Attribute("historicalBytes");
    private final byte[] bytes;

    protected static HistoricalBytes create(ICardConnection connection) {
        ATR atr = connection.getCard().getAtr();
        if (atr.getHistoricalBytesSize() == 0) {
            try {
                RequestAPDU request = new RequestAPDU(0, 202, 95, 82, 0, false);
                request.setLabel("read historical bytes");
                ResponseAPDU response = connection.transmit(request);
                if (response.getSw() == 36864) {
                    return new HistoricalBytes(response.getData());
                }
                return null;
            }
            catch (CardException e) {
                return new HistoricalBytes(new byte[0]);
            }
        }
        return new HistoricalBytes(atr.getHistoricalBytes());
    }

    public static HistoricalBytes get(ICardConnection connection) {
        HistoricalBytes result = (HistoricalBytes)connection.getCard().getAttribute((Object)ATTR_HISTORICALBYTES);
        if (result == null) {
            result = HistoricalBytes.create(connection);
        }
        return result;
    }

    protected HistoricalBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean isStatusIndicatorPresent() {
        if (this.bytes.length < 1) {
            return false;
        }
        return this.bytes[0] == 0;
    }
}

