/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.sm;

import de.intarsys.security.io.MacOutputStream;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardTransmitter;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;

public abstract class SecureMessaging
extends CommonCardTransmitter {
    protected static final byte[] BYTES_ZERO = new byte[]{0};
    public static final int CONTEXT_SPECIFIC_CLASS_END = 191;
    public static final int CONTEXT_SPECIFIC_CLASS_START = 128;
    public static final int CLA_MASK_SM = 12;
    private static final int BYTE_ODD = 1;
    public static final byte ISO_PADDING_STARTBYTE = -128;
    public static final byte ISO_PADDING_BYTE = 0;
    public static final byte PADDING_INDICATOR_UNKNOWN = 0;
    public static final byte PADDING_INDICATOR_ISO = 1;
    public static final byte PADDING_INDICATOR_NONE = 2;
    public static final int TAG_CryptoBER = 133;
    public static final int TAG_CryptoPlain = 135;
    public static final int TAG_Checksum = 142;
    public static final int TAG_LE = 151;
    public static final int TAG_Plain = 129;
    public static final int TAG_Status = 153;
    private int paddingIndicator = 1;
    private byte[] sendSequenceCounter;
    private IAlgorithmFactory algorithmFactory;
    private int checksumLength = -1;

    protected SecureMessaging(ICardTransmitter transmitter) {
        super(transmitter);
    }

    protected byte[] createChecksum(RequestAPDU request, TlvTemplate template) throws IOException, GeneralSecurityException {
        Mac mac = this.getAlgorithmFactory().createMac(this.getSendSequenceCounter());
        MacOutputStream mos = new MacOutputStream(null, mac);
        mos.write((int)((byte)(request.getCla() | 0xC)));
        mos.write((int)((byte)request.getIns()));
        mos.write((int)((byte)request.getP1()));
        mos.write((int)((byte)request.getP2()));
        this.pad((OutputStream)mos, this.getAlgorithmFactory().getMacBlockLength(), 4);
        this.createChecksumWriteTemplate(mos, template);
        byte[] checksum = mac.doFinal();
        if (this.getChecksumLength() == -1) {
            return checksum;
        }
        return Arrays.copyOf(checksum, this.getChecksumLength());
    }

    protected byte[] createChecksum(ResponseAPDU response, TlvTemplate template) throws IOException, GeneralSecurityException {
        Mac mac = this.getAlgorithmFactory().createMac(this.getSendSequenceCounter());
        MacOutputStream mos = new MacOutputStream(null, mac);
        this.createChecksumWriteTemplate(mos, template);
        byte[] checksum = mac.doFinal();
        if (this.getChecksumLength() == -1) {
            return checksum;
        }
        return Arrays.copyOf(checksum, this.getChecksumLength());
    }

    protected void createChecksumWriteTemplate(MacOutputStream mos, TlvTemplate template) throws IOException {
        int length = 0;
        boolean padAfter = false;
        boolean padBetween = false;
        for (TlvElement element : template) {
            int tag = element.getIdentifier();
            if (this.isEven(tag) && tag >= 128 && tag <= 191) {
                padBetween = true;
                continue;
            }
            if (padBetween) {
                padBetween = false;
                this.pad((OutputStream)mos, this.getAlgorithmFactory().getMacBlockLength(), length);
            }
            byte[] data = element.getEncoded();
            mos.write(data, 0, data.length);
            length += data.length;
            padAfter = true;
        }
        if (padAfter) {
            this.pad((OutputStream)mos, this.getAlgorithmFactory().getMacBlockLength(), length);
        }
    }

    protected RequestAPDU createSmRequest(RequestAPDU request, TlvTemplate smTemplate) throws CardException {
        byte claEnc = (byte)(request.getCla() | 0xC);
        RequestAPDU smReq = new RequestAPDU((int)claEnc, request.getIns(), request.getP1(), request.getP2(), smTemplate.getEncoded(), 0, false);
        smReq.setLabel(request.getLabel());
        smReq.setExtendedApdu(true);
        return smReq;
    }

    protected ResponseAPDU createSmResponse(ResponseAPDU response, TlvTemplate smTemplate) throws CardException {
        return new ResponseAPDU(smTemplate.getEncoded(), response.getSw1(), response.getSw2());
    }

    protected byte[] decodeTlvData(TlvTemplate template) throws IOException, GeneralSecurityException {
        TlvElement tlvCryptogram = template.getElementTagged(133);
        if (tlvCryptogram == null) {
            tlvCryptogram = template.getElementTagged(132);
        }
        if (tlvCryptogram != null) {
            byte[] bytes = tlvCryptogram.getValue();
            return this.decrypt(bytes, 0, bytes.length);
        }
        tlvCryptogram = template.getElementTagged(135);
        if (tlvCryptogram == null) {
            tlvCryptogram = template.getElementTagged(134);
        }
        if (tlvCryptogram != null) {
            byte[] bytes = tlvCryptogram.getValue();
            return this.decryptPadded(bytes, 0, bytes.length);
        }
        return null;
    }

    protected int decodeTlvLe(TlvTemplate template) throws IOException, GeneralSecurityException {
        TlvElement tlvCryptogram = template.getElementTagged(151);
        if (tlvCryptogram == null) {
            return -1;
        }
        byte[] leBytes = tlvCryptogram.getValue();
        if (leBytes.length == 0) {
            return 0;
        }
        if (leBytes.length == 1) {
            return leBytes[0];
        }
        if (leBytes.length == 2) {
            return (leBytes[0] << 8) + (leBytes[1] & 0xFF);
        }
        return 0;
    }

    protected int decodeTlvStatus(TlvTemplate template, int sw) throws CardException {
        TlvElement tlvStatus = template.getElementTagged(153);
        if (tlvStatus == null) {
            throw new CardException("secure messaging response status required");
        }
        byte[] status = tlvStatus.getValue();
        if (status.length == 2) {
            return ((status[0] & 0xFF) << 8) + (status[1] & 0xFF);
        }
        throw new CardException("secure messaging response status mismatch");
    }

    protected byte[] decrypt(byte[] data, int offset, int length) throws IOException, GeneralSecurityException {
        Cipher cipher = this.getAlgorithmFactory().createCipher(2, this.getSendSequenceCounter());
        return cipher.doFinal(data, offset, length);
    }

    protected byte[] decryptPadded(byte[] data, int offset, int length) throws IOException, GeneralSecurityException {
        if (length == 0) {
            throw new IOException("cryptogram 0x87 invalid padding");
        }
        byte padding = data[offset];
        if (padding == 1) {
            byte[] decrypted = this.decrypt(data, offset + 1, length - 1);
            for (int i = decrypted.length - 1; i >= 0; --i) {
                if (decrypted[i] == -128) {
                    return Arrays.copyOf(decrypted, i);
                }
                if (decrypted[i] == 0) continue;
                return decrypted;
            }
            return decrypted;
        }
        if (padding == 2) {
            return this.decrypt(data, offset + 1, length - 1);
        }
        throw new IOException("cryptogram 0x87 unsupported padding " + padding);
    }

    protected TlvElement encodeTlvChecksum(RequestAPDU request, TlvTemplate smTemplate) throws IOException, GeneralSecurityException {
        return new Iso7816BerElement(142, this.createChecksum(request, smTemplate));
    }

    protected TlvElement encodeTlvChecksum(ResponseAPDU response, TlvTemplate smTemplate) throws IOException, GeneralSecurityException {
        return new Iso7816BerElement(142, this.createChecksum(response, smTemplate));
    }

    protected TlvElement encodeTlvDataEncrypted(RequestAPDU request) throws IOException, GeneralSecurityException {
        boolean unformatted = this.isEven(request.getIns());
        byte[] data = request.getData();
        byte[] encrypted = this.encrypt(data, 0, data.length, unformatted);
        if (unformatted) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.getPaddingIndicator());
            bos.write(encrypted, 0, encrypted.length);
            return new Iso7816BerElement(135, bos.toByteArray());
        }
        return new Iso7816BerElement(133, encrypted);
    }

    protected TlvElement encodeTlvDataEncrypted(ResponseAPDU response) throws IOException, GeneralSecurityException {
        byte[] data = response.getData();
        byte[] encrypted = this.encrypt(data, 0, data.length, true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.getPaddingIndicator());
        bos.write(encrypted, 0, encrypted.length);
        return new Iso7816BerElement(135, bos.toByteArray());
    }

    protected TlvElement encodeTlvDataPlain(RequestAPDU request) {
        return new Iso7816BerElement(129, request.getData());
    }

    protected TlvElement encodeTlvDataPlain(ResponseAPDU response) {
        return new Iso7816BerElement(129, response.getData());
    }

    protected TlvElement encodeTlvLe(RequestAPDU request) {
        int le = request.getLe();
        if (le == -1) {
            return null;
        }
        if (request.isExtendedApdu()) {
            return new Iso7816BerElement(151, new byte[]{(byte)(le >> 8 & 0xFF), (byte)(le & 0xFF)});
        }
        return new Iso7816BerElement(151, new byte[]{(byte)le});
    }

    protected TlvElement encodeTlvStatus(ResponseAPDU response) {
        return new Iso7816BerElement(153, new byte[]{(byte)response.getSw1(), (byte)response.getSw2()});
    }

    protected byte[] encrypt(byte[] data, int offset, int length, boolean pad) throws IOException, GeneralSecurityException {
        Cipher cipher = this.getAlgorithmFactory().createCipher(1, this.getSendSequenceCounter());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(bos, cipher);
        cos.write(data, offset, length);
        if (pad) {
            this.pad(cos, this.getAlgorithmFactory().getCipherBlockLength(), length);
        }
        cos.close();
        return bos.toByteArray();
    }

    public IAlgorithmFactory getAlgorithmFactory() {
        return this.algorithmFactory;
    }

    public int getChecksumLength() {
        return this.checksumLength;
    }

    public int getPaddingIndicator() {
        return this.paddingIndicator;
    }

    protected byte[] getSendSequenceCounter() {
        return this.sendSequenceCounter;
    }

    protected void incSendSequenceCounter() {
        for (int i = this.sendSequenceCounter.length - 1; i >= 0; --i) {
            int n = i;
            this.sendSequenceCounter[n] = (byte)(this.sendSequenceCounter[n] + 1);
            if (this.sendSequenceCounter[i] != 0) break;
        }
    }

    protected boolean isEven(int value) {
        return (value & 1) == 0;
    }

    protected void pad(OutputStream cos, int blockLength, int length) throws IOException {
        int modulo = length % blockLength;
        cos.write(-128);
        for (int i = blockLength - modulo - 1; i > 0; --i) {
            cos.write(0);
        }
    }

    public void setAlgorithmFactory(IAlgorithmFactory cipherFactory) {
        this.algorithmFactory = cipherFactory;
        this.sendSequenceCounter = new byte[this.getAlgorithmFactory().getCipherBlockLength()];
    }

    public void setChecksumLength(int checksumLength) {
        this.checksumLength = checksumLength;
    }

    public void setPaddingIndicator(int paddingIndicator) {
        this.paddingIndicator = paddingIndicator;
    }

    public static interface IAlgorithmFactory {
        public Cipher createCipher(int var1, byte[] var2) throws GeneralSecurityException;

        public Mac createMac(byte[] var1) throws GeneralSecurityException;

        public int getCipherBlockLength();

        public int getMacBlockLength();
    }
}

