/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.sm;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.sm.SecureMessaging;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerInputStream;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Arrays;

public class SecureMessagingReceiver
extends SecureMessaging {
    public SecureMessagingReceiver(ICardTransmitter transmitter) {
        super(transmitter);
    }

    protected RequestAPDU decodeRequest(RequestAPDU request) throws CardException {
        try {
            int cla = request.getCla();
            if ((cla & 0xC) != 12) {
                return request;
            }
            cla = request.getCla() & 0xFFFFFFF3;
            int ins = request.getIns();
            int p1 = request.getP1();
            int p2 = request.getP2();
            byte[] bytes = request.getData();
            Iso7816BerInputStream is = new Iso7816BerInputStream(bytes, 0, bytes.length);
            TlvTemplate template = new TlvTemplate((TlvInputStream)is);
            byte[] macLocal = this.createChecksum(request, template);
            TlvElement macDo = template.getElementTagged(142);
            if (macDo == null) {
                throw new CardException("secure message MAC missing");
            }
            if (!Arrays.equals(macLocal, macDo.getValue())) {
                throw new CardException("secure message MAC mismatch");
            }
            byte[] data = this.decodeTlvData(template);
            int le = this.decodeTlvLe(template);
            RequestAPDU decoded = new RequestAPDU(cla, ins, p1, p2, data, le, false);
            decoded.setLabel(request.getLabel());
            return decoded;
        }
        catch (CardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CardException("secure messaging can't decode apdu", (Throwable)e);
        }
    }

    protected ResponseAPDU decodeResponse(ResponseAPDU response) throws CardException {
        return this.encodeResponse(response);
    }

    protected RequestAPDU encodeRequest(RequestAPDU request) throws CardException {
        return this.decodeRequest(request);
    }

    protected ResponseAPDU encodeResponse(ResponseAPDU response) throws CardException {
        try {
            TlvTemplate smTemplate = new TlvTemplate();
            if (response.getData() != null) {
                if (this.getAlgorithmFactory() != null) {
                    smTemplate.addElement(this.encodeTlvDataEncrypted(response));
                } else {
                    smTemplate.addElement(this.encodeTlvDataPlain(response));
                }
            }
            smTemplate.addElement(this.encodeTlvStatus(response));
            smTemplate.addElement(this.encodeTlvChecksum(response, smTemplate));
            return this.createSmResponse(response, smTemplate);
        }
        catch (CardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CardException("secure messaging can't encode apdu", (Throwable)e);
        }
    }
}

