/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.sm;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.sm.SecureMessaging;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerInputStream;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class SecureMessagingSender
extends SecureMessaging {
    private static final Logger Log = LoggerFactory.getLogger(SecureMessagingSender.class);

    public SecureMessagingSender(ICardTransmitter transmitter) {
        super(transmitter);
    }

    protected ResponseAPDU decodeResponse(ResponseAPDU response) throws CardException {
        this.incSendSequenceCounter();
        if (!response.hasData()) {
            return response;
        }
        try {
            Iso7816BerInputStream is = new Iso7816BerInputStream(response.getInputStream());
            TlvTemplate template = new TlvTemplate((TlvInputStream)is);
            byte[] macLocal = this.createChecksum(response, template);
            TlvElement macDo = template.getElementTagged(142);
            if (macDo == null) {
                throw new CardException("secure message MAC missing");
            }
            if (!Arrays.equals(macLocal, macDo.getValue())) {
                throw new CardException("secure message MAC mismatch");
            }
            byte[] data = this.decodeTlvData(template);
            if (data != null) {
                this.logBytes("<<", data, 0, data.length, false);
            } else {
                this.logBytes("<<", data, 0, 0, false);
            }
            int sw = this.decodeTlvStatus(template, response.getSw());
            return new ResponseAPDU(data, sw);
        }
        catch (CardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CardException("secure messaging can't decode apdu", (Throwable)e);
        }
    }

    protected RequestAPDU encodeRequest(RequestAPDU request) throws CardException {
        try {
            TlvElement tlvLe;
            byte[] bytes = request.getBytes();
            this.logBytes(">>", bytes, 0, bytes.length, request.isSensitiveContent());
            this.incSendSequenceCounter();
            TlvTemplate smTemplate = new TlvTemplate();
            if (request.getData() != null) {
                if (this.getAlgorithmFactory() != null) {
                    smTemplate.addElement(this.encodeTlvDataEncrypted(request));
                } else {
                    smTemplate.addElement(this.encodeTlvDataPlain(request));
                }
            }
            if ((tlvLe = this.encodeTlvLe(request)) != null) {
                smTemplate.addElement(tlvLe);
            }
            smTemplate.addElement(this.encodeTlvChecksum(request, smTemplate));
            return this.createSmRequest(request, smTemplate);
        }
        catch (CardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CardException("secure messaging can't encode apdu", (Throwable)e);
        }
    }

    protected Object getLogLabel() {
        return "SM";
    }

    protected void logBytes(String mode, byte[] bytes, int offset, int length, boolean sensitiveContent) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            String strLength = String.format("%04d", length);
            Object strData = sensitiveContent ? (bytes == null ? "" : HexTools.bytesToHexString((byte[])bytes, (int)offset, (int)4, (boolean)true) + " <sensitive content omitted>") : (bytes == null ? "" : HexTools.bytesToHexString((byte[])bytes, (int)offset, (int)length, (boolean)true));
            Log.trace("{} {} [{}]: {}", new Object[]{this.getLogLabel(), mode, strLength, strData});
        }
    }

    public String toString() {
        return "SM";
    }
}

