/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.tlv;

import de.intarsys.security.smartcard.iso.tlv.Iso7816BerInputStream;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;

public class Iso7816BerElement
extends TlvElement {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iso7816BerElement parseElement(byte[] encoded, int offset, int length) throws IOException {
        Iso7816BerElement iso7816BerElement;
        Iso7816BerInputStream is = null;
        try {
            is = new Iso7816BerInputStream(encoded, offset, length);
            iso7816BerElement = (Iso7816BerElement)is.readElement();
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close((Closeable)((Object)is));
        return iso7816BerElement;
    }

    public static TlvTemplate parseTemplate(byte[] encoded, int offset, int length) throws IOException {
        Iso7816BerInputStream is = new Iso7816BerInputStream(encoded, offset, length);
        return new TlvTemplate((TlvInputStream)is);
    }

    public Iso7816BerElement(int identifier, byte[] buffer) {
        super(identifier, buffer);
    }

    public Iso7816BerElement(int identifier, byte[] buffer, int offset, int length) {
        super(identifier, buffer, offset, length);
    }

    public TlvInputStream createTlvInputStream(byte[] pBytes, int pOffset, int pLength) throws TlvFormatException {
        return new Iso7816BerInputStream(pBytes, pOffset, pLength);
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean started = false;
        int mask = -16777216;
        int value = this.getIdentifier();
        int shift = 24;
        while (mask != 0) {
            int temp = (value & mask) >>> shift;
            mask >>>= 8;
            shift -= 8;
            if (temp == 0 && !started) continue;
            started = true;
            out.write(temp);
        }
        if (this.getLength() < 128) {
            out.write(this.getLength());
        } else if (this.getLength() <= 255) {
            out.write(129);
            out.write(this.getLength());
        } else if (this.getLength() <= 65535) {
            out.write(130);
            out.write(this.getLength() >> 8 & 0xFF);
            out.write(this.getLength() & 0xFF);
        } else if (this.getLength() <= 0xFFFFFF) {
            out.write(131);
            out.write(this.getLength() >> 16 & 0xFF);
            out.write(this.getLength() >> 8 & 0xFF);
            out.write(this.getLength() & 0xFF);
        } else {
            throw new IllegalArgumentException("length not supported");
        }
        out.write(this.buffer, this.offset, this.buffer.length);
        return out.toByteArray();
    }

    public boolean isComposite() {
        return false;
    }
}

