/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.tlv;

import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Iso7816BerInputStream
extends TlvInputStream {
    private boolean ignoreFF = true;

    public Iso7816BerInputStream(byte[] data, int offset, int length) {
        this(new ByteArrayInputStream(data, offset, length));
    }

    public Iso7816BerInputStream(InputStream in) {
        super(in);
    }

    protected void checkUnexpectedEndOfInput(int i, String msg) throws IOException {
        if (i == -1) {
            throw new IOException(msg);
        }
    }

    public boolean isIgnoreFF() {
        return this.ignoreFF;
    }

    public TlvElement readElement() throws IOException {
        int i = this.readNonZero();
        if (i == -1) {
            return null;
        }
        int identifier = i;
        if ((i & 0x1F) == 31) {
            i = this.read();
            this.checkUnexpectedEndOfInput(i, "unexpected end of input");
            while ((i & 0x80) != 0) {
                identifier = (identifier << 8) + i;
                i = this.read();
                this.checkUnexpectedEndOfInput(i, "unexpected end of input");
            }
            identifier = (identifier << 8) + i;
        }
        i = this.read();
        this.checkUnexpectedEndOfInput(i, "unexpected end of input (length missing)");
        int length = i;
        if ((length & 0x80) != 0) {
            int numBytes = length & 0x7F;
            if (numBytes > 3) {
                throw new IOException("length " + numBytes + " not supported");
            }
            length = 0;
            while (numBytes > 0) {
                length <<= 8;
                i = this.read();
                if (i == -1) break;
                --numBytes;
                length += i;
            }
        }
        byte[] data = new byte[length];
        int offset = 0;
        while (length > 0 && (i = this.read(data, offset, length)) != -1) {
            offset += i;
            length -= i;
        }
        if (length != 0) {
            throw new IOException("unexpected end of input (data missing)");
        }
        return new Iso7816BerElement(identifier, data);
    }

    protected int readNonZero() throws IOException {
        int i = this.read();
        while (i == 0 || i == 255 && this.isIgnoreFF()) {
            i = this.read();
        }
        return i;
    }

    public void setIgnoreFF(boolean ignoreFF) {
        this.ignoreFF = ignoreFF;
    }
}

