/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.tlv;

import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleInputStream;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;

public class Iso7816CompactElement
extends TlvElement {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iso7816CompactElement parseElement(byte[] encoded, int offset, int length) throws IOException {
        Iso7816CompactElement iso7816CompactElement;
        Iso7816SimpleInputStream is = null;
        try {
            is = new Iso7816SimpleInputStream(encoded, offset, length);
            iso7816CompactElement = (Iso7816CompactElement)is.readElement();
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close((Closeable)((Object)is));
        return iso7816CompactElement;
    }

    public static TlvTemplate parseTemplate(byte[] encoded, int offset, int length) throws IOException {
        Iso7816SimpleInputStream is = new Iso7816SimpleInputStream(encoded, offset, length);
        return new TlvTemplate((TlvInputStream)is);
    }

    public Iso7816CompactElement(int identifier, byte[] buffer) {
        super(identifier, buffer);
        if (identifier < 0 || identifier > 15) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public Iso7816CompactElement(int identifier, byte[] buffer, int offset, int length) {
        super(identifier, buffer, offset, length);
        if (identifier < 0 || identifier > 15) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public TlvInputStream createTlvInputStream(byte[] pBytes, int pOffset, int pLength) throws TlvFormatException {
        return new Iso7816SimpleInputStream(pBytes, pOffset, pLength);
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int firstByte = this.getIdentifier() << 4;
        out.write(firstByte |= this.getLength());
        out.write(this.buffer, this.offset, this.length);
        return out.toByteArray();
    }

    public boolean isComposite() {
        return false;
    }
}

