/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.tlv;

import de.intarsys.security.smartcard.iso.tlv.Iso7816CompactElement;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Iso7816CompactInputStream
extends TlvInputStream {
    public Iso7816CompactInputStream(byte[] data, int offset, int length) {
        this(new ByteArrayInputStream(data, offset, length));
    }

    public Iso7816CompactInputStream(InputStream in) {
        super(in);
    }

    public TlvElement readElement() throws IOException {
        int length;
        int i = this.read();
        while (i == 0) {
            i = this.read();
        }
        if (i == -1) {
            return null;
        }
        int tag = i >> 4 & 0xF;
        byte[] data = new byte[length];
        int offset = 0;
        for (length = i & 0xF; length > 0 && (i = this.read(data, offset, length)) != -1; length -= i) {
            offset += i;
        }
        if (length != 0) {
            throw new IOException("unexpected end of input (data missing)");
        }
        return new Iso7816CompactElement(tag, data);
    }
}

