/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.iso.tlv;

import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleInputStream;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;

public class Iso7816SimpleElement
extends TlvElement {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iso7816SimpleElement parseElement(byte[] encoded, int offset, int length) throws IOException {
        Iso7816SimpleElement iso7816SimpleElement;
        Iso7816SimpleInputStream is = null;
        try {
            is = new Iso7816SimpleInputStream(encoded, offset, length);
            iso7816SimpleElement = (Iso7816SimpleElement)is.readElement();
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close((Closeable)((Object)is));
        return iso7816SimpleElement;
    }

    public static TlvTemplate parseTemplate(byte[] encoded, int offset, int length) throws IOException {
        Iso7816SimpleInputStream is = new Iso7816SimpleInputStream(encoded, offset, length);
        return new TlvTemplate((TlvInputStream)is);
    }

    public Iso7816SimpleElement(int identifier, byte data) {
        this(identifier, new byte[]{data});
    }

    public Iso7816SimpleElement(int identifier, byte[] buffer) {
        super(identifier, buffer);
        if (identifier <= 0 || identifier >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public Iso7816SimpleElement(int identifier, byte[] buffer, int offset, int length) {
        super(identifier, buffer, offset, length);
        if (identifier <= 0 || identifier >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public TlvInputStream createTlvInputStream(byte[] pBytes, int pOffset, int pLength) throws TlvFormatException {
        return new Iso7816SimpleInputStream(pBytes, pOffset, pLength);
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.getIdentifier());
        if (this.getLength() < 255) {
            out.write(this.getLength());
        } else if (this.getLength() <= 65535) {
            out.write(255);
            out.write(this.getLength() >> 8 & 0xFF);
            out.write(this.getLength() & 0xFF);
        } else {
            throw new IllegalArgumentException("size > 0xFFFF not supported");
        }
        out.write(this.buffer, this.offset, this.length);
        return out.toByteArray();
    }

    public boolean isComposite() {
        return false;
    }
}

