/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiCardInfo;
import de.intarsys.security.smartcard.model.ICardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.GenericCardApplicationFactory;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.GenericFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CardApplicationInfo<A extends CardApplicationAdapter>
implements ICardApplicationInfo<A>,
IElementConfigurable {
    private GenericCardApplicationFactory<A> cardApplicationFactory;
    private final List<CardApplicationBinding> bindings = new ArrayList<CardApplicationBinding>();
    private final CiCardInfo cardInfo;

    public CardApplicationInfo(CiCardInfo cardInfo) {
        this.cardInfo = cardInfo;
    }

    @Override
    public void addBinding(CardApplicationBinding binding) {
        this.bindings.add(binding);
    }

    public void configure(IElement element) throws ConfigurationException {
        this.cardApplicationFactory = this.configureCardApplicationFactory(element);
        this.configureBindings(element);
    }

    protected void configureBindings(IElement element) throws ConfigurationException {
        IElement elBindings = ElementTools.getElement((IElement)element, (String)"bindings");
        if (elBindings != null) {
            this.bindings.clear();
            Iterator itItems = elBindings.elementIterator("binding");
            while (itItems.hasNext()) {
                CardApplicationBinding binding = new CardApplicationBinding();
                IElement elItem = (IElement)itItems.next();
                String certId = elItem.attributeValue("certificate", null);
                ICardHolderCertificateInfo certInfo = (ICardHolderCertificateInfo)this.getCardInfo().lookupCardCertificateInfo(certId);
                if (certInfo == null) {
                    throw new ConfigurationException("certificate " + certId + " not found");
                }
                String mechanismIds = elItem.attributeValue("mechanisms", null);
                if (!StringTools.isEmpty((String)mechanismIds)) {
                    String[] names;
                    for (String name : names = mechanismIds.split(",")) {
                        IMechanism mechanism = certInfo.getPrivateKeyInfo().lookupMechanism(name);
                        if (mechanism == null) {
                            throw new ConfigurationException("mechanism " + name + " for certificate " + certId + " not found");
                        }
                        binding.addMechanism(mechanism);
                    }
                } else {
                    for (IMechanism mechanism : certInfo.getPrivateKeyInfo().getMechanisms()) {
                        binding.addMechanism(mechanism);
                    }
                }
                binding.setCardHolderCertificateInfo(certInfo);
                this.bindings.add(binding);
            }
        }
    }

    protected GenericCardApplicationFactory configureCardApplicationFactory(IElement elApplication) throws ConfigurationException {
        GenericFactory baseFactory = new GenericFactory();
        baseFactory.setConfigNameResultClass("type");
        baseFactory.configure(elApplication);
        try {
            baseFactory.validate();
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        GenericCardApplicationFactory factory = new GenericCardApplicationFactory(baseFactory);
        return factory;
    }

    @Override
    public A createCardApplication(ICardConnection connection, ICardProduct product) throws CardApplicationException {
        CardApplicationAdapter app = (CardApplicationAdapter)this.cardApplicationFactory.createCardApplication(connection, product, this);
        return (A)app;
    }

    @Override
    public List<CardApplicationBinding> getBindings() {
        return this.bindings;
    }

    public GenericCardApplicationFactory getCardApplicationFactory() {
        return this.cardApplicationFactory;
    }

    @Override
    public Class getCardApplicationType() {
        return this.getCardApplicationFactory().getCardApplicationType();
    }

    @Override
    public CiCardInfo getCardInfo() {
        return this.cardInfo;
    }

    protected void setBindings(Collection<CardApplicationBinding> bindings) {
        this.bindings.clear();
        this.bindings.addAll(bindings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CardApplicationInfo ");
        sb.append(this.getCardInfo().getLabel());
        sb.append(" - ");
        sb.append(this.getCardApplicationType());
        return sb.toString();
    }
}

