/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.ICardAttributeCertificate;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.util.Map;

public class CardAttributeCertificate
extends CardCertificate
implements ICardAttributeCertificate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardAttributeCertificate create(ICardProduct product, ICardConnection connection, ICardCertificateInfo info) {
        Map<CardFileSelector, CardCertificate> certs;
        Map<CardFileSelector, CardCertificate> map = certs = CardAttributeCertificate.basicGetCardCertificates(connection.getCard());
        synchronized (map) {
            CardCertificate cert = certs.get(info.getSelector());
            if (cert == null) {
                try {
                    IX509Certificate x509Cert = CardCertificate.load(product, connection, info.getSelector());
                    cert = new CardAttributeCertificate(connection.getCard(), info, x509Cert);
                }
                catch (CardApplicationException e) {
                    cert = CardCertificate.FAILED;
                }
                certs.put(info.getSelector(), cert);
            }
            if (cert == CardCertificate.FAILED) {
                return null;
            }
            return (CardAttributeCertificate)cert;
        }
    }

    protected CardAttributeCertificate(ICard card, ICardCertificateInfo info, IX509Certificate certificate) {
        super(card, info, certificate);
    }

    protected IX509AttributeCertificate getAttributeCertificate() {
        return (IX509AttributeCertificate)this.getCertificate();
    }

    public IX509CertificateReference getIssuer() {
        return this.getAttributeCertificate().getIssuer();
    }

    public IX509CertificateReference getSubject() {
        return this.getAttributeCertificate().getSubject();
    }

    public boolean match(IX509PublicKeyCertificate certificate) {
        return this.getAttributeCertificate().match(certificate);
    }
}

