/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.FileInputStream;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardCertificate;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CardCertificate
implements ICardCertificate {
    protected static final CardCertificate FAILED = new CardCertificate(null, null, null);
    protected static final Attribute ATTR_CARDCERTIFICATES = new Attribute("cardCertificates");
    protected static final Attribute ATTR_PKCARDCERTIFICATES = new Attribute("pkCardCertificates");
    private static final Logger Log = LoggerFactory.getLogger(CardCertificate.class);
    private final ICard card;
    private final ICardCertificateInfo info;
    private final IX509Certificate certificate;
    private ICertificateProvider certificateProvider;
    private final AttributeMap attributes = new AttributeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<CardFileSelector, CardCertificate> basicGetCardCertificates(ICard card) {
        Attribute attribute = ATTR_CARDCERTIFICATES;
        synchronized (attribute) {
            HashMap<CardFileSelector, CardCertificate> certificates = (HashMap<CardFileSelector, CardCertificate>)card.getAttribute((Object)ATTR_CARDCERTIFICATES);
            if (certificates == null) {
                certificates = new HashMap<CardFileSelector, CardCertificate>();
                card.setAttribute((Object)ATTR_CARDCERTIFICATES, certificates);
            }
            return certificates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cachePKCardCertificates(ICard card, List<ICardPublicKeyCertificate> result) {
        Attribute attribute = ATTR_PKCARDCERTIFICATES;
        synchronized (attribute) {
            card.setAttribute((Object)ATTR_PKCARDCERTIFICATES, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCardCertificates(ICard card) {
        Attribute attribute = ATTR_CARDCERTIFICATES;
        synchronized (attribute) {
            card.setAttribute((Object)ATTR_CARDCERTIFICATES, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<CardFileSelector, CardCertificate> getCardCertificates(ICard card) {
        Attribute attribute = ATTR_CARDCERTIFICATES;
        synchronized (attribute) {
            return new HashMap<CardFileSelector, CardCertificate>(CardCertificate.basicGetCardCertificates(card));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ICardPublicKeyCertificate> getPKCardCertificates(ICard card) {
        Attribute attribute = ATTR_PKCARDCERTIFICATES;
        synchronized (attribute) {
            List tmp = (List)card.getAttribute((Object)ATTR_PKCARDCERTIFICATES);
            return tmp == null ? null : new ArrayList<ICardPublicKeyCertificate>(tmp);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IX509Certificate load(ICardProduct product, ICardConnection connection, CardFileSelector selector) throws CardApplicationException {
        IX509Certificate iX509Certificate;
        FileInputStream is = null;
        try {
            IFileSystemApplication fileSystem = product.createCardApplication(connection, IFileSystemApplication.class);
            is = new FileInputStream(fileSystem, selector);
            is.mark(1);
            int i = is.read();
            if (i <= 0 || i == 255) {
                String msg = "certificate in file [" + selector + "] not loaded, file empty";
                Log.debug(msg);
                throw new CardFileNotFoundException(106, 130);
            }
            is.reset();
            IX509Certificate result = X509CertificateFactory.get().createCertificate((InputStream)is);
            String msg = "certificate in file [" + selector + "] loaded";
            Log.debug(msg);
            iX509Certificate = result;
        }
        catch (CardFileNotFoundException e) {
            try {
                String msg = "certificate in file [" + selector + "] not loaded, file not found";
                Log.debug(msg);
                throw e;
                catch (Exception e2) {
                    msg = "certificate in file [" + selector + "] not loaded: file error " + e2.getLocalizedMessage();
                    if (Log.isEnabledForLevel(Level.TRACE)) {
                        Log.trace(msg, (Throwable)e2);
                        throw CardApplicationException.create(e2);
                    }
                    Log.debug(msg);
                    throw CardApplicationException.create(e2);
                }
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                throw throwable;
            }
        }
        StreamTools.close((Closeable)is);
        return iX509Certificate;
    }

    protected CardCertificate(ICard card, ICardCertificateInfo info, IX509Certificate certificate) {
        this.info = info;
        this.card = card;
        this.certificate = certificate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == this.certificate) {
            return true;
        }
        if (obj instanceof CardCertificate) {
            CardCertificate other = (CardCertificate)obj;
            return LangTools.equals((Object)this.certificate, (Object)other.certificate);
        }
        return LangTools.equals((Object)this.certificate, (Object)obj);
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public ICard getCard() {
        return this.card;
    }

    protected Object getCardFileSelector() {
        return this.info.getSelector();
    }

    protected IX509Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] getCertificateInfo() throws CertificateEncodingException {
        return this.getCertificate().getCertificateInfo();
    }

    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.getCertificate().getCriticalExtensionOIDs();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getCertificate().getEncoded();
    }

    public byte[] getExtensionValue(String oid) {
        return this.getCertificate().getExtensionValue(oid);
    }

    @Override
    public ICardCertificateInfo getInfo() {
        return this.info;
    }

    public boolean[] getIssuerUniqueID() {
        return this.getCertificate().getIssuerUniqueID();
    }

    public X500Principal getIssuerX500Principal() {
        return this.getCertificate().getIssuerX500Principal();
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.getCertificate().getNonCriticalExtensionOIDs();
    }

    public Date getNotAfter() {
        return this.getCertificate().getNotAfter();
    }

    public Date getNotBefore() {
        return this.getCertificate().getNotBefore();
    }

    public BigInteger getSerialNumber() {
        return this.getCertificate().getSerialNumber();
    }

    public String getSigAlgName() {
        return this.getCertificate().getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.getCertificate().getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.getCertificate().getSigAlgParams();
    }

    public byte[] getSignature() {
        return this.getCertificate().getSignature();
    }

    public X500Principal getSubjectX500Principal() {
        return this.getCertificate().getSubjectX500Principal();
    }

    public String getType() {
        return this.getCertificate().getType();
    }

    public int getVersion() {
        return this.getCertificate().getVersion();
    }

    public IX509Attribute getX509Attribute(String oid) {
        return this.getCertificate().getX509Attribute(oid);
    }

    public IX509Attribute[] getX509Attributes() {
        return this.getCertificate().getX509Attributes();
    }

    public IX509Extension getX509Extension(String oid) {
        return this.certificate.getX509Extension(oid);
    }

    public IX509Extension[] getX509Extensions() {
        return this.certificate.getX509Extensions();
    }

    public int hashCode() {
        return CertificateTools.hashCode((IX509Certificate)this);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.getCertificate().hasUnsupportedCriticalExtension();
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributes.put(key, o);
    }

    public void setCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path: ");
        sb.append(this.getCardFileSelector().toString());
        if (this.certificate != null) {
            sb.append(", loaded");
            sb.append("\n");
            sb.append(this.getCertificate().toString());
        } else {
            sb.append(", not loaded");
        }
        return sb.toString();
    }
}

