/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardFileTools;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;

public class CardCertificateInfo
implements ICardCertificateInfo {
    private final CertificateUsage certificateUsage;
    private final CardFileSelector certPath;
    private final String id;

    public CardCertificateInfo(String name, CardFileSelector certificateFilePath, CertificateUsage pCertificateUse) {
        this.certPath = certificateFilePath;
        this.certificateUsage = pCertificateUse;
        this.id = name;
    }

    public CardCertificateInfo(String name, String certificateFilePath, CertificateUsage pCertificateUse) {
        this(name, new CardFilePath(certificateFilePath), pCertificateUse);
    }

    @Override
    public CertificateUsage getCertificateUsage() {
        return this.certificateUsage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CardFileSelector getSelector() {
        return this.certPath;
    }

    @Override
    public CardCertificateInfo relocate(CardFileSelector dir) {
        CardFileSelector tempCertPath = this.getSelector();
        tempCertPath = CardFileTools.resolve(dir, tempCertPath);
        return new CardCertificateInfo(this.getId(), tempCertPath, this.getCertificateUsage());
    }
}

