/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardAttributeCertificate;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.CardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.ICardAttributeCertificate;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.IPrivateKeyInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CardHolderCertificate
extends CardPublicKeyCertificate
implements ICardHolderCertificate {
    private Set<ICardAttributeCertificate> attributeCertificates;
    private Set<ICardPublicKeyCertificate> caCertificates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardHolderCertificate create(ICardProduct product, ICardConnection connection, ICardHolderCertificateInfo info) {
        Map<CardFileSelector, CardCertificate> certs;
        ICard card = connection.getCard();
        Map<CardFileSelector, CardCertificate> map = certs = CardHolderCertificate.basicGetCardCertificates(card);
        synchronized (map) {
            CardCertificate cert = certs.get(info.getSelector());
            if (cert == null) {
                try {
                    IX509Certificate x509Cert = CardCertificate.load(product, connection, info.getSelector());
                    cert = new CardHolderCertificate(connection.getCard(), info, x509Cert);
                    ((CardHolderCertificate)cert).createAttributeCertificates(product, connection);
                    ((CardHolderCertificate)cert).createCACertificates(product, connection);
                }
                catch (CardApplicationException e) {
                    cert = CardCertificate.FAILED;
                }
                certs.put(info.getSelector(), cert);
            }
            if (cert == CardCertificate.FAILED) {
                return null;
            }
            return (CardHolderCertificate)cert;
        }
    }

    protected CardHolderCertificate(ICard card, ICardCertificateInfo info, IX509Certificate certificate) {
        super(card, info, certificate);
    }

    protected void createAttributeCertificates(ICardProduct product, ICardConnection connection) {
        ICardCertificateInfo[] infos = this.getInfo().getAttributeCertificateInfos();
        this.attributeCertificates = new HashSet<ICardAttributeCertificate>(infos.length);
        for (ICardCertificateInfo info : infos) {
            CardAttributeCertificate cert = CardAttributeCertificate.create(product, connection, info);
            if (cert == null) continue;
            this.attributeCertificates.add(cert);
        }
    }

    protected void createCACertificates(ICardProduct product, ICardConnection connection) {
        ICardCertificateInfo[] infos = this.getInfo().getCACertificateInfos();
        this.caCertificates = new HashSet<ICardPublicKeyCertificate>(infos.length);
        for (ICardCertificateInfo info : infos) {
            CardPublicKeyCertificate cert = CardPublicKeyCertificate.create(product, connection, info);
            if (cert == null) continue;
            this.caCertificates.add(cert);
        }
    }

    @Override
    public Set<ICardAttributeCertificate> getAttributeCertificates() {
        return this.attributeCertificates;
    }

    @Override
    public Set<ICardPublicKeyCertificate> getCACertificates() {
        return this.caCertificates;
    }

    @Override
    public ICardHolderCertificateInfo getInfo() {
        return (ICardHolderCertificateInfo)super.getInfo();
    }

    @Override
    public IPinInfo getPinInfo() {
        return this.getInfo().getPinInfo();
    }

    @Override
    public IPrivateKeyInfo getPrivateKeyInfo() {
        return this.getInfo().getPrivateKeyInfo();
    }
}

