/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardFileTools;
import de.intarsys.security.smartcard.model.CardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.IPrivateKeyInfo;

public class CardHolderCertificateInfo
extends CardCertificateInfo
implements ICardHolderCertificateInfo {
    private final ICardCertificateInfo[] attributeCertificateInfos;
    private final ICardCertificateInfo[] caCertificateInfos;
    private final IPrivateKeyInfo privateKeyInfo;
    private final IPinInfo pinInfo;

    public CardHolderCertificateInfo(String name, CardFileSelector pCertPath, CertificateUsage pCertificateUse, IPrivateKeyInfo privateKeyInfo, IPinInfo pinInfo, ICardCertificateInfo[] pAttributeCertPaths, ICardCertificateInfo[] pCaCertificatePaths) {
        super(name, pCertPath, pCertificateUse);
        this.privateKeyInfo = privateKeyInfo;
        this.pinInfo = pinInfo;
        this.attributeCertificateInfos = pAttributeCertPaths == null ? new ICardCertificateInfo[]{} : pAttributeCertPaths;
        this.caCertificateInfos = pCaCertificatePaths == null ? new ICardCertificateInfo[]{} : pCaCertificatePaths;
    }

    public CardHolderCertificateInfo(String name, String certPath, CertificateUsage certificateUse, IPrivateKeyInfo privateKeyInfo, IPinInfo pinInfo, ICardCertificateInfo[] pAttributeCertPaths, ICardCertificateInfo[] pCaCertificatePaths) {
        this(name, new CardFilePath(certPath), certificateUse, privateKeyInfo, pinInfo, pAttributeCertPaths, pCaCertificatePaths);
    }

    @Override
    public ICardCertificateInfo[] getAttributeCertificateInfos() {
        return this.attributeCertificateInfos;
    }

    @Override
    public ICardCertificateInfo[] getCACertificateInfos() {
        return this.caCertificateInfos;
    }

    @Override
    public IPinInfo getPinInfo() {
        return this.pinInfo;
    }

    @Override
    public IPrivateKeyInfo getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    @Override
    public CardHolderCertificateInfo relocate(CardFileSelector dir) {
        CardFileSelector tempCertPath = this.getSelector();
        tempCertPath = CardFileTools.resolve(dir, tempCertPath);
        IPrivateKeyInfo tempPrivateKeyInfo = this.getPrivateKeyInfo().relocate(dir);
        ICardCertificateInfo[] tempAttributeCertPaths = new ICardCertificateInfo[this.getAttributeCertificateInfos().length];
        for (int i = 0; i < this.getAttributeCertificateInfos().length; ++i) {
            ICardCertificateInfo info = this.getAttributeCertificateInfos()[i];
            tempAttributeCertPaths[i] = info.relocate(dir);
        }
        ICardCertificateInfo[] tempCACertPaths = new ICardCertificateInfo[this.getCACertificateInfos().length];
        for (int i = 0; i < this.getCACertificateInfos().length; ++i) {
            ICardCertificateInfo info = this.getCACertificateInfos()[i];
            tempCACertPaths[i] = info.relocate(dir);
        }
        return new CardHolderCertificateInfo(this.getId(), tempCertPath, this.getCertificateUsage(), tempPrivateKeyInfo, this.getPinInfo(), tempAttributeCertPaths, tempCACertPaths);
    }
}

