/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.common.ICardStateApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardApplicationCardNotSupported;
import de.intarsys.security.smartcard.model.CardProductOutlet;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.system.SystemTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CardProductTools {
    private static final Logger Log = LoggerFactory.getLogger(CardProductTools.class);
    private static final Attribute ATTR_CARDPRODUCT = new Attribute("cardProduct");

    public static ICardProduct getCardProduct(ICard card) {
        return (ICardProduct)card.getAttribute((Object)ATTR_CARDPRODUCT);
    }

    public static ICardProduct getCardProduct(ICardConnection connection) throws CardApplicationException {
        ICardProduct cardProduct = (ICardProduct)connection.getCard().getAttribute((Object)ATTR_CARDPRODUCT);
        if (cardProduct == null) {
            for (ICardProductFactory factory : CardProductOutlet.get().getCardProductFactories()) {
                if (SystemTools.isWindows()) {
                    try {
                        connection.getStatus();
                    }
                    catch (CardException e) {
                        throw CardApplicationException.create(e);
                    }
                }
                if ((cardProduct = factory.create(connection)) == null) continue;
                connection.getCard().setAttribute((Object)ATTR_CARDPRODUCT, (Object)cardProduct);
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    CardProductTools.logCardState(cardProduct, connection, Level.TRACE);
                }
                return cardProduct;
            }
            throw new CardApplicationCardNotSupported();
        }
        return cardProduct;
    }

    public static void logCardState(ICardProduct product, ICardConnection connection, Level level) {
        try {
            ICardStateApplication app = product.createCardApplication(connection, ICardStateApplication.class);
            Log.atLevel(level).log("+ Card state Name: " + app.getName());
            Log.atLevel(level).log("+ Card state Issuer: " + app.getIssuer());
            Log.atLevel(level).log("+ Card state Firmware: " + app.getFirmwareVersion());
            Log.atLevel(level).log("+ Card state Hardware: " + app.getHardwareVersion());
            Log.atLevel(level).log("+ Card state Label: " + app.getLabel());
            Log.atLevel(level).log("+ Card state Serial: " + app.getSerialNumber());
        }
        catch (Exception e) {
            Log.atLevel(level).log("+ Card state logging error " + e.getLocalizedMessage());
        }
    }

    private CardProductTools() {
    }
}

