/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.standard.validation.QCTools;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CardPublicKeyCertificate
extends CardCertificate
implements ICardPublicKeyCertificate {
    private final CertificateUsage certificateUsage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardPublicKeyCertificate create(ICardProduct product, ICardConnection connection, ICardCertificateInfo info) {
        Map<CardFileSelector, CardCertificate> certs;
        ICard card = connection.getCard();
        Map<CardFileSelector, CardCertificate> map = certs = CardPublicKeyCertificate.basicGetCardCertificates(card);
        synchronized (map) {
            CardCertificate cert = certs.get(info.getSelector());
            if (cert == null) {
                try {
                    IX509Certificate x509Cert = CardCertificate.load(product, connection, info.getSelector());
                    cert = new CardPublicKeyCertificate(connection.getCard(), info, x509Cert);
                }
                catch (CardApplicationException e) {
                    cert = CardCertificate.FAILED;
                }
                certs.put(info.getSelector(), cert);
            }
            if (cert == CardCertificate.FAILED) {
                return null;
            }
            return (CardPublicKeyCertificate)cert;
        }
    }

    protected CardPublicKeyCertificate(ICard card, ICardCertificateInfo info, IX509Certificate certificate) {
        super(card, info, certificate);
        String[] qualifiers = null;
        try {
            if (QCTools.isQualificationPostulated((IX509Certificate)this)) {
                qualifiers = new String[]{"qualifiedCertificate"};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.certificateUsage = new CertificateUsage(info.getCertificateUsage(), qualifiers);
    }

    public String getAlias() {
        return null;
    }

    public int getBasicConstraints() {
        return this.getPublicKeyCertificate().getBasicConstraints();
    }

    public CertificateUsage getCertificateUsage() {
        return this.certificateUsage;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        return this.getPublicKeyCertificate().getExtendedKeyUsage();
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return this.getPublicKeyCertificate().getIssuerAlternativeNames();
    }

    public int getKeyBitSize() {
        return this.getPublicKeyCertificate().getKeyBitSize();
    }

    public boolean[] getKeyUsage() {
        return this.getPublicKeyCertificate().getKeyUsage();
    }

    public PublicKey getPublicKey() {
        return this.getPublicKeyCertificate().getPublicKey();
    }

    protected IX509PublicKeyCertificate getPublicKeyCertificate() {
        return (IX509PublicKeyCertificate)this.getCertificate();
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return this.getPublicKeyCertificate().getSubjectAlternativeNames();
    }

    public boolean[] getSubjectUniqueID() {
        return this.getPublicKeyCertificate().getSubjectUniqueID();
    }

    public X509Certificate toJavaCertificate() throws CertificateException {
        return this.getPublicKeyCertificate().toJavaCertificate();
    }
}

