/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.CardResponseMap;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import java.util.HashMap;
import java.util.Map;

public class CardResponseHandler {
    private Map<String, CardResponseMap> responseMaps = new HashMap<String, CardResponseMap>();

    public void addResponseMap(String ins, String sw1, String sw2, Class<? extends CardStatusCodeException> exceptionClass, String message) {
        String key = (ins + "-" + sw1 + "-" + sw2).toLowerCase();
        this.responseMaps.put(key, CardResponseMap.create(ins, sw1, sw2, exceptionClass, message));
    }

    public void checkResponse(RequestAPDU req, ResponseAPDU resp) throws CardApplicationException {
        int ins = req == null ? 0 : req.getIns();
        Object key = this.hex(ins) + "-" + this.hex(resp.getSw1()) + "-" + this.hex(resp.getSw2());
        CardResponseMap map = this.lookupResponseMap((String)key);
        if (map == null) {
            key = this.hex(ins) + "-" + this.hex(resp.getSw1()) + "-" + this.hex(resp.getSw2() >> 4) + "*";
            map = this.lookupResponseMap((String)key);
        }
        if (map == null) {
            key = this.hex(ins) + "-" + this.hex(resp.getSw1()) + "-*";
            map = this.lookupResponseMap((String)key);
        }
        if (map == null) {
            key = "*-" + this.hex(resp.getSw1()) + "-" + this.hex(resp.getSw2());
            map = this.lookupResponseMap((String)key);
        }
        if (map == null) {
            key = "*-" + this.hex(resp.getSw1()) + "-" + this.hex(resp.getSw2() >> 4) + "*";
            map = this.lookupResponseMap((String)key);
        }
        if (map == null) {
            key = "*-" + this.hex(resp.getSw1()) + "-*";
            map = this.lookupResponseMap((String)key);
        }
        if (map == null) {
            key = "*-*-*";
            map = this.lookupResponseMap((String)key);
        }
        if (map != null) {
            map.checkResponse(req, resp);
        }
    }

    protected String hex(int value) {
        return Integer.toHexString(value);
    }

    protected CardResponseMap lookupResponseMap(String key) {
        return this.responseMaps.get(key.toLowerCase());
    }
}

