/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import java.lang.reflect.Constructor;

public class CardResponseMap {
    private String ins;
    private String sw1;
    private String sw2;
    private Class<? extends CardStatusCodeException> exceptionClass;
    private String message;

    public static CardResponseMap create(String ins, String sw1, String sw2, Class<? extends CardStatusCodeException> exceptionClass, String message) {
        return new CardResponseMap(ins, sw1, sw2, exceptionClass, message);
    }

    public CardResponseMap(String ins, String sw1, String sw2, Class<? extends CardStatusCodeException> exceptionClass, String message) {
        this.ins = ins;
        this.sw1 = sw1;
        this.sw2 = sw2;
        this.exceptionClass = exceptionClass;
        this.message = message;
    }

    public void checkResponse(RequestAPDU req, ResponseAPDU resp) throws CardApplicationException {
        Constructor<? extends CardStatusCodeException> c;
        if (this.exceptionClass == null) {
            return;
        }
        CardApplicationException cae = null;
        try {
            c = this.exceptionClass.getConstructor(Integer.TYPE, Integer.TYPE, String.class);
            cae = c.newInstance(resp.getSw1(), resp.getSw2(), this.message);
        }
        catch (Exception c2) {
            // empty catch block
        }
        if (cae == null) {
            try {
                c = this.exceptionClass.getConstructor(Integer.TYPE, Integer.TYPE);
                cae = c.newInstance(resp.getSw1(), resp.getSw2());
            }
            catch (Exception c3) {
                // empty catch block
            }
        }
        if (cae == null) {
            try {
                c = this.exceptionClass.getConstructor(String.class);
                cae = c.newInstance(this.message);
            }
            catch (Exception c4) {
                // empty catch block
            }
        }
        if (cae == null) {
            try {
                c = this.exceptionClass.getConstructor(new Class[0]);
                cae = c.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cae == null) {
            cae = new CardStatusCodeException(resp.getSw1(), resp.getSw2(), this.message);
        }
        throw cae;
    }

    public Class<? extends CardApplicationException> getExceptionClass() {
        return this.exceptionClass;
    }

    public String getIns() {
        return this.ins;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSw1() {
        return this.sw1;
    }

    public String getSw2() {
        return this.sw2;
    }

    public void setExceptionClass(Class<? extends CardStatusCodeException> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public void setIns(String ins) {
        this.ins = ins;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSw1(String sw1) {
        this.sw1 = sw1;
    }

    public void setSw2(String sw2) {
        this.sw2 = sw2;
    }
}

