/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiFileSystem;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardFile;
import de.intarsys.security.smartcard.model.ICardFileSystem;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardInfo;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.IPrivateKeyInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CiCardInfo
implements ICardInfo {
    private final Map<Class<?>, ICardApplicationInfo> cardApplicationInfos = new HashMap();
    private final List<ICardCertificateInfo> cardCertificateInfos = new ArrayList<ICardCertificateInfo>();
    private final ICardFileSystem fileSystem = new CiFileSystem();
    private String label;
    private IMessageBundle messageBundle;
    private final List<IPinInfo> pinInfos = new ArrayList<IPinInfo>();
    private final List<IPrivateKeyInfo> privateKeyInfos = new ArrayList<IPrivateKeyInfo>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private Boolean supportsExtendedApdu = false;
    private String pkcs15Name;
    private String applicationName;
    private Pkcs15Structure pkcs15Structure;

    protected Map<Class<?>, ICardApplicationInfo> basicGetCardApplicationInfos() {
        return this.cardApplicationInfos;
    }

    public List<ICardCertificateInfo> basicGetCardCertificateInfos() {
        return this.cardCertificateInfos;
    }

    public List<IPinInfo> basicGetPinInfos() {
        return this.pinInfos;
    }

    protected List<IPrivateKeyInfo> basicGetPrivateKeyInfos() {
        return this.privateKeyInfos;
    }

    protected Map<String, String> basicGetProperties() {
        return this.properties;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public Collection<ICardApplicationInfo> getCardApplicationInfos() {
        return new ArrayList<ICardApplicationInfo>(this.cardApplicationInfos.values());
    }

    @Override
    public Collection<ICardCertificateInfo> getCardCertificateInfos() {
        return new ArrayList<ICardCertificateInfo>(this.cardCertificateInfos);
    }

    @Override
    public Collection<ICardHolderCertificateInfo> getCardHolderCertificateInfos() {
        Collection<ICardCertificateInfo> infos = this.getCardCertificateInfos();
        ArrayList<ICardHolderCertificateInfo> result = new ArrayList<ICardHolderCertificateInfo>();
        for (ICardCertificateInfo info : infos) {
            if (!(info instanceof ICardHolderCertificateInfo)) continue;
            result.add((ICardHolderCertificateInfo)info);
        }
        return result;
    }

    @Override
    public ICardFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected byte[] getHistoricalBytes(ICardConnection connection) {
        byte[] result = null;
        return result;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public IMessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    @Override
    public Collection<IPinInfo> getPinInfos() {
        return new ArrayList<IPinInfo>(this.pinInfos);
    }

    public String getPkcs15Name() {
        return this.pkcs15Name;
    }

    public Pkcs15Structure getPkcs15Structure() {
        return this.pkcs15Structure;
    }

    @Override
    public Collection<IPrivateKeyInfo> getPrivateKeyInfos() {
        return new ArrayList<IPrivateKeyInfo>(this.privateKeyInfos);
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Boolean getSupportsExtendedApdu() {
        return this.supportsExtendedApdu;
    }

    public boolean isSupportsExtendedApdu() {
        if (this.supportsExtendedApdu == null) {
            return false;
        }
        return this.supportsExtendedApdu;
    }

    @Override
    public ICardApplicationInfo lookupCardApplicationInfo(Class<? extends ICardApplication> cardAppClass) {
        return this.basicGetCardApplicationInfos().get(cardAppClass);
    }

    @Override
    public ICardCertificateInfo lookupCardCertificateInfo(String name) {
        if (name == null) {
            return null;
        }
        for (ICardCertificateInfo info : this.getCardCertificateInfos()) {
            if (!name.equals(info.getId())) continue;
            return info;
        }
        return null;
    }

    @Override
    public CardFileSelector lookupFileSelector(String name) {
        ICardFile file = this.getFileSystem().lookupFile(name);
        if (file == null) {
            return null;
        }
        return file.asSelector();
    }

    @Override
    public IPinInfo lookupPinInfo(String name) {
        if (name == null) {
            return null;
        }
        for (IPinInfo info : this.basicGetPinInfos()) {
            if (!name.equals(info.getId())) continue;
            return info;
        }
        return null;
    }

    @Override
    public IPrivateKeyInfo lookupPrivateKeyInfo(String name) {
        if (name == null) {
            return null;
        }
        for (IPrivateKeyInfo info : this.basicGetPrivateKeyInfos()) {
            if (!name.equals(info.getId())) continue;
            return info;
        }
        return null;
    }

    @Override
    public String lookupProperty(String name) {
        return this.properties.get(name);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public void setPkcs15Name(String pkcs15Name) {
        this.pkcs15Name = pkcs15Name;
    }

    public void setPkcs15Structure(Pkcs15Structure pkcs15Structure) {
        this.pkcs15Structure = pkcs15Structure;
    }

    public void setSupportsExtendedApdu(Boolean supportsExtendedApdu) {
        this.supportsExtendedApdu = supportsExtendedApdu;
    }

    @Override
    public boolean supportsExtendedApdu() {
        return this.isSupportsExtendedApdu();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CiCardInfo ");
        sb.append(this.getLabel());
        return sb.toString();
    }
}

