/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.common.CommonPinCodec;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinCodecAscii;
import de.intarsys.security.smartcard.common.PinCodecBcd;
import de.intarsys.security.smartcard.common.PinCodecFormat2;
import de.intarsys.security.smartcard.model.CardApplicationInfo;
import de.intarsys.security.smartcard.model.CardCertificateInfo;
import de.intarsys.security.smartcard.model.CardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.CiCardInfo;
import de.intarsys.security.smartcard.model.CiCardInfoBuilder;
import de.intarsys.security.smartcard.model.CiFile;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.IPrivateKeyInfo;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.PrivateKeyInfo;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CiCardInfoConfigurationBuilder
extends CiCardInfoBuilder {
    protected static final String ISA_AID = "aid";
    private static final String ISA_ALGORITHM_ID = "algorithmId";
    private static final String ISA_ALGORITHM_REF = "algorithmRef";
    private static final String ISA_BLOCKSIZE = "blocksize";
    private static final String ISA_CONTENT = "content";
    private static final String ISA_DESCRIPTION = "description";
    private static final String ISA_DIRECTORY = "directory";
    private static final String ISA_ENCRYPTION_ALGORITHM = "encryptionAlgorithm";
    private static final String ISA_FILE = "file";
    private static final String ISA_FILE_ID = "fileId";
    private static final String ISA_FILE_NAME = "fileName";
    private static final String ISA_FIXED = "fixed";
    private static final String ISA_HASH_ALGORITHMS = "hashAlgorithms";
    private static final String ISA_HIDDEN = "hidden";
    private static final String ISA_ID = "id";
    private static final String ISA_INPUT_ENCODING = "inputEncoding";
    private static final String ISA_LABEL = "label";
    private static final String ISA_LOOKUP = "lookup";
    private static final String ISA_MAX = "max";
    private static final String ISA_MIN = "min";
    private static final String ISA_NAME = "name";
    private static final String ISA_OPERATION = "operation";
    private static final String ISA_OUTPUT_ENCODING = "outputEncoding";
    private static final String ISA_PAD = "pad";
    private static final String ISA_PIN = "pin";
    private static final String ISA_PRIVATE_KEY = "privateKey";
    private static final String ISA_REF = "ref";
    private static final String ISA_KEYID = "keyId";
    private static final String ISA_RESET = "reset";
    private static final String ISA_RETRY_COUNTER_ONLY = "retryCounterOnly";
    private static final String ISA_TRANSPORT_LABEL = "transportLabel";
    private static final String ISA_TRANSPORT_LENGTH = "transportLength";
    private static final String ISA_TRANSPORT_VALUE = "transportValue";
    private static final String ISA_TYPE = "type";
    private static final String ISA_USAGE = "usage";
    private static final String ISA_VALUE = "value";
    private static final String ISE_APPLICATION = "application";
    private static final String ISE_APPLICATIONS = "applications";
    private static final String ISE_ATTRIBUTE_CERTIFICATES = "attributeCertificates";
    private static final String ISE_CA_CERTIFICATES = "caCertificates";
    private static final String ISE_CERTIFICATE = "certificate";
    private static final String ISE_CERTIFICATES = "certificates";
    protected static final String ISE_CIA = "cia";
    private static final String ISE_CODEC = "codec";
    private static final String ISE_EXTENDED_APDU = "extendedAPDU";
    private static final String ISE_FILE_SYSTEM = "fileSystem";
    private static final String ISE_FILES = "files";
    private static final String ISE_MECHANISM = "mechanism";
    private static final String ISE_MECHANISMS = "mechanisms";
    private static final String ISE_PINS = "pins";
    private static final String ISE_PRIVATE_KEY = "privateKey";
    private static final String ISE_PRIVATE_KEYS = "privateKeys";
    private static final String ISE_PROPERTIES = "properties";
    private static final String ISE_PROPERTY = "property";
    private static final String TYPE_ASCII = "ASCII";
    private static final String TYPE_BCD = "BCD";
    private static final String TYPE_FORMAT2 = "FORMAT2";
    private final IElement configuration;

    public CiCardInfoConfigurationBuilder(IElement configuration) {
        this.configuration = configuration;
    }

    protected void configAccess(CiCardInfo cardInfo, CiFile target, IElement elContainer) {
        IElement elList = ElementTools.getElement((IElement)elContainer, (String)ISE_FILES);
        if (elList != null) {
            ArrayList<CiFile> result = new ArrayList<CiFile>();
            Iterator itElements = elList.elementIterator(ISA_FILE);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                CiFile file = this.configFile(cardInfo, target, elElement);
                result.add(file);
            }
            target.setFiles(result);
        }
    }

    protected CardApplicationInfo<?> configCardApplicationInfo(CiCardInfo cardInfo, IElement elElement) throws ConfigurationException {
        CardApplicationInfo info = new CardApplicationInfo(cardInfo);
        info.configure(elElement);
        return info;
    }

    protected void configCardApplicationInfos(CiCardInfo cardInfo, IElement elCard) throws ConfigurationException {
        IElement elList = ElementTools.getElement((IElement)elCard, (String)ISE_APPLICATIONS);
        if (elList != null) {
            Iterator itElements = elList.elementIterator(ISE_APPLICATION);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                CardApplicationInfo<?> info = this.configCardApplicationInfo(cardInfo, elElement);
                if (cardInfo.basicGetCardApplicationInfos().put(info.getCardApplicationType(), info) == null) continue;
                throw new IllegalStateException("info " + info.getCardApplicationType() + " already registered");
            }
        }
    }

    protected CardCertificateInfo configCardCertificateInfo(CiCardInfo cardInfo, IElement elCertificate) throws ConfigurationException {
        CardFileSelector selector;
        String name = elCertificate.attributeValue(ISA_ID, null);
        String fileId = elCertificate.attributeValue(ISA_FILE, null);
        if (fileId == null) {
            fileId = name;
        }
        if ((selector = cardInfo.lookupFileSelector(name)) == null) {
            throw new IllegalArgumentException("certificate file " + name + " not found");
        }
        String usageName = elCertificate.attributeValue(ISA_USAGE, null);
        CertificateUsage usage = CertificateUsage.createFromName((String)usageName);
        String privateKeyId = elCertificate.attributeValue("privateKey", null);
        IPrivateKeyInfo pkInfo = cardInfo.lookupPrivateKeyInfo(privateKeyId);
        if (pkInfo == null) {
            return new CardCertificateInfo(name, selector, usage);
        }
        String pinId = elCertificate.attributeValue(ISA_PIN, null);
        IPinInfo pinInfo = cardInfo.lookupPinInfo(pinId);
        if (pinInfo == null) {
            throw new IllegalStateException("pin can't be null");
        }
        IElement elList = ElementTools.getElement((IElement)elCertificate, (String)ISE_ATTRIBUTE_CERTIFICATES);
        List<ICardCertificateInfo> attrCerts = this.configCardCertificateInfoAssociations(cardInfo, elList);
        elList = ElementTools.getElement((IElement)elCertificate, (String)ISE_CA_CERTIFICATES);
        List<ICardCertificateInfo> caCerts = this.configCardCertificateInfoAssociations(cardInfo, elList);
        return new CardHolderCertificateInfo(name, selector, usage, pkInfo, pinInfo, attrCerts.toArray(new ICardCertificateInfo[attrCerts.size()]), caCerts.toArray(new ICardCertificateInfo[caCerts.size()]));
    }

    protected List<ICardCertificateInfo> configCardCertificateInfoAssociations(CiCardInfo cardInfo, IElement elList) throws ConfigurationException {
        ArrayList<ICardCertificateInfo> result = new ArrayList<ICardCertificateInfo>();
        if (elList != null) {
            Iterator itElements = elList.elementIterator(ISE_CERTIFICATE);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                String ref = elElement.attributeValue(ISA_LOOKUP, null);
                ICardCertificateInfo info = cardInfo.lookupCardCertificateInfo(ref);
                if (info == null) {
                    throw new IllegalStateException("certificate can't be null");
                }
                result.add(info);
            }
        }
        return result;
    }

    protected void configCardCertificateInfos(CiCardInfo cardInfo, IElement elCard) throws ConfigurationException {
        IElement elList = ElementTools.getElement((IElement)elCard, (String)ISE_CERTIFICATES);
        if (elList != null) {
            Iterator itElements = elList.elementIterator(ISE_CERTIFICATE);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                CardCertificateInfo ci = this.configCardCertificateInfo(cardInfo, elElement);
                cardInfo.basicGetCardCertificateInfos().add(ci);
            }
        }
    }

    protected IPinCodec configCodec(CiCardInfo cardInfo, IElement elCodec) {
        CommonPinCodec codec;
        if (elCodec == null) {
            return null;
        }
        String type = elCodec.attributeValue(ISA_TYPE, null);
        int pad = ElementTools.getInt((IElement)elCodec, (String)ISA_PAD, (int)-1);
        int min = ElementTools.getInt((IElement)elCodec, (String)ISA_MIN, (int)-1);
        int max = ElementTools.getInt((IElement)elCodec, (String)ISA_MAX, (int)-1);
        int blocksize = ElementTools.getInt((IElement)elCodec, (String)ISA_BLOCKSIZE, (int)-1);
        if (TYPE_ASCII.equals(type)) {
            codec = new PinCodecAscii(pad, min, max);
        } else if (TYPE_BCD.equals(type)) {
            codec = new PinCodecBcd(pad, min, max);
        } else if (TYPE_FORMAT2.equals(type)) {
            codec = new PinCodecFormat2(pad, min, max);
        } else {
            throw new IllegalArgumentException("pin type " + type + " unknown");
        }
        if (blocksize != -1) {
            codec.setBlockSize(blocksize);
        }
        return codec;
    }

    protected CiFile configFile(CiCardInfo cardInfo, CiFile parent, IElement elFile) {
        CiFile file = new CiFile();
        file.setParent(parent);
        file.setFileId(ElementTools.getString((IElement)elFile, (String)ISA_FILE_ID, null));
        file.setFileName(ElementTools.getString((IElement)elFile, (String)ISA_FILE_NAME, null));
        file.setId(ElementTools.getString((IElement)elFile, (String)ISA_ID, null));
        file.setLabel(ElementTools.getString((IElement)elFile, (String)ISA_LABEL, null));
        file.setDescription(ElementTools.getString((IElement)elFile, (String)ISA_DESCRIPTION, null));
        file.setContent(ElementTools.getString((IElement)elFile, (String)ISA_CONTENT, null));
        this.configAccess(cardInfo, file, elFile);
        this.configFiles(cardInfo, file, elFile);
        return file;
    }

    protected void configFiles(CiCardInfo cardInfo, CiFile parent, IElement elContainer) {
        IElement elList = ElementTools.getElement((IElement)elContainer, (String)ISE_FILES);
        if (elList != null) {
            ArrayList<CiFile> result = new ArrayList<CiFile>();
            Iterator itElements = elList.elementIterator(ISA_FILE);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                CiFile file = this.configFile(cardInfo, parent, elElement);
                result.add(file);
            }
            parent.setFiles(result);
        }
    }

    protected void configFileSystem(CiCardInfo cardInfo, IElement elCard) {
        IElement elFs = elCard.element(ISE_FILE_SYSTEM);
        if (elFs != null) {
            this.configFiles(cardInfo, (CiFile)cardInfo.getFileSystem().getRoot(), elFs);
        }
    }

    protected Map<String, String> configGenericProperties(CiCardInfo cardInfo, IElement elContainer, Map<String, String> properties) {
        IElement elList = ElementTools.getElement((IElement)elContainer, (String)ISE_PROPERTIES);
        if (elList != null) {
            Iterator itElements = elList.elementIterator(ISE_PROPERTY);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                properties.put(elElement.attributeValue(ISA_NAME, null), elElement.attributeValue(ISA_VALUE, null));
            }
        }
        return properties;
    }

    protected List<IMechanism> configMechanisms(CiCardInfo cardInfo, IElement elContainer) throws ConfigurationException {
        ArrayList<IMechanism> result = new ArrayList<IMechanism>();
        IElement elList = ElementTools.getElement((IElement)elContainer, (String)ISE_MECHANISMS);
        if (elList == null) {
            return result;
        }
        Iterator itElements = elList.elementIterator(ISE_MECHANISM);
        while (itElements.hasNext()) {
            IElement el = (IElement)itElements.next();
            Mechanism mech = new Mechanism();
            mech.setId(ElementTools.getString((IElement)el, (String)ISA_ID, null));
            mech.setOperation(ElementTools.getString((IElement)el, (String)ISA_OPERATION, null));
            mech.setAlgorithmId(ElementTools.getString((IElement)el, (String)ISA_ALGORITHM_ID, null));
            mech.setAlgorithmRef(ElementTools.getInt((IElement)el, (String)ISA_ALGORITHM_REF, (int)-1));
            mech.setOutputEncodingAlgorithmName(ElementTools.getString((IElement)el, (String)ISA_OUTPUT_ENCODING, null));
            mech.setInputEncodingAlgorithmName(ElementTools.getString((IElement)el, (String)ISA_INPUT_ENCODING, null));
            mech.setHashAlgorithmNames(ElementTools.getString((IElement)el, (String)ISA_HASH_ALGORITHMS, null));
            result.add(mech);
        }
        return result;
    }

    protected IPinInfo configPinInfo(CiCardInfo cardInfo, IElement elPin) throws ConfigurationException {
        PinInfo pinInfo;
        String id = elPin.attributeValue(ISA_ID, null);
        String name = elPin.attributeValue(ISA_DIRECTORY, null);
        CardFileSelector dir = cardInfo.lookupFileSelector(name);
        if (dir == null) {
            throw new IllegalArgumentException("pin directory " + name + " not found");
        }
        int ref = ElementTools.getInt((IElement)elPin, (String)ISA_REF, (int)-1);
        IElement elCodec = elPin.element(ISE_CODEC);
        IPinCodec codec = this.configCodec(cardInfo, elCodec);
        boolean fixed = ElementTools.getBool((IElement)elPin, (String)ISA_FIXED, (boolean)false);
        boolean hidden = ElementTools.getBool((IElement)elPin, (String)ISA_HIDDEN, (boolean)false);
        int transportLength = ElementTools.getInt((IElement)elPin, (String)ISA_TRANSPORT_LENGTH, (int)-1);
        String transportLabel = ElementTools.getString((IElement)elPin, (String)ISA_TRANSPORT_LABEL, null);
        String transportValue = HexTools.hexStringToString((String)ElementTools.getString((IElement)elPin, (String)ISA_TRANSPORT_VALUE, null));
        String resetId = ElementTools.getString((IElement)elPin, (String)ISA_RESET, null);
        if (resetId != null) {
            IPinInfo resettedPin = cardInfo.lookupPinInfo(resetId);
            boolean retryCounterOnly = ElementTools.getBool((IElement)elPin, (String)ISA_RETRY_COUNTER_ONLY, (boolean)false);
            pinInfo = PinInfo.createResetPinInfo(resettedPin, id, ref, codec, dir, retryCounterOnly);
        } else {
            pinInfo = new PinInfo(id, ref, codec, dir);
        }
        pinInfo.setFixed(fixed);
        pinInfo.setHidden(hidden);
        pinInfo.setTransportLength(transportLength);
        pinInfo.setTransportLabel(transportLabel);
        if (transportValue != null) {
            pinInfo.setTransportValue(transportValue.toCharArray());
        }
        pinInfo.setProperties(this.configGenericProperties(cardInfo, elPin, new HashMap<String, String>()));
        this.configPinInfoLabel(cardInfo, pinInfo, null);
        return pinInfo;
    }

    protected void configPinInfos(CiCardInfo cardInfo, IElement elCard) throws ConfigurationException {
        IElement elList = ElementTools.getElement((IElement)elCard, (String)ISE_PINS);
        if (elList != null) {
            Iterator itElements = elList.elementIterator(ISA_PIN);
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                IPinInfo info = this.configPinInfo(cardInfo, elElement);
                cardInfo.basicGetPinInfos().add(info);
            }
        }
    }

    protected PrivateKeyInfo configPrivateKeyInfo(CiCardInfo cardInfo, IElement elPrivate) throws ConfigurationException {
        String dirName = elPrivate.attributeValue(ISA_DIRECTORY, null);
        CardFileSelector dir = cardInfo.lookupFileSelector(dirName);
        if (dir == null) {
            throw new IllegalArgumentException("private key directory " + dirName + " not found");
        }
        String id = ElementTools.getString((IElement)elPrivate, (String)ISA_ID, null);
        String keyIdString = ElementTools.getString((IElement)elPrivate, (String)ISA_KEYID, null);
        byte[] keyId = null;
        if (StringTools.isEmpty((String)keyIdString)) {
            int ref = ElementTools.getInt((IElement)elPrivate, (String)ISA_REF, (int)-1);
            if (ref != -1) {
                keyId = new byte[]{(byte)ref};
            }
        } else {
            keyId = HexTools.hexStringToBytes((String)keyIdString);
        }
        String encryptionAlgorithmName = ElementTools.getString((IElement)elPrivate, (String)ISA_ENCRYPTION_ALGORITHM, (String)"RSA");
        List<IMechanism> mechanisms = this.configMechanisms(cardInfo, elPrivate);
        return new PrivateKeyInfo(id, dir, keyId, encryptionAlgorithmName, mechanisms);
    }

    protected void configPrivateKeyInfos(CiCardInfo cardInfo, IElement elCard) throws ConfigurationException {
        IElement elList = ElementTools.getElement((IElement)elCard, (String)ISE_PRIVATE_KEYS);
        if (elList != null) {
            Iterator itElements = elList.elementIterator("privateKey");
            while (itElements.hasNext()) {
                IElement elElement = (IElement)itElements.next();
                PrivateKeyInfo info = this.configPrivateKeyInfo(cardInfo, elElement);
                cardInfo.basicGetPrivateKeyInfos().add(info);
            }
        }
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    @Override
    public void process(CiCardInfo cardInfo) throws ConfigurationException {
        IElement cia;
        super.process(cardInfo);
        IElement elExtApdu = this.getConfiguration().element(ISE_EXTENDED_APDU);
        if (elExtApdu != null) {
            String value = elExtApdu.attributeValue(ISA_VALUE, "false");
            if ("true".equals(value)) {
                cardInfo.setSupportsExtendedApdu(true);
            } else if ("auto".equals(value)) {
                cardInfo.setSupportsExtendedApdu(null);
            } else {
                cardInfo.setSupportsExtendedApdu(false);
            }
        }
        String aidName = (cia = this.getConfiguration().element(ISE_CIA)) == null ? null : cia.attributeValue(ISA_AID, null);
        cardInfo.setPkcs15Name(aidName);
        this.configFileSystem(cardInfo, this.getConfiguration());
        this.configGenericProperties(cardInfo, this.getConfiguration(), cardInfo.basicGetProperties());
        this.configPrivateKeyInfos(cardInfo, this.getConfiguration());
        this.configPinInfos(cardInfo, this.getConfiguration());
        this.configCardCertificateInfos(cardInfo, this.getConfiguration());
        this.configCardApplicationInfos(cardInfo, this.getConfiguration());
    }
}

