/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.CardApplicationInfo;
import de.intarsys.security.smartcard.model.CiCardInfo;
import de.intarsys.security.smartcard.model.CiCardInfoConfigurationBuilder;
import de.intarsys.security.smartcard.model.CiCardProductFactory;
import de.intarsys.security.smartcard.model.CommonCardProduct;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardFile;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardOperatingSystem;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardApplicationNotSupported;
import de.intarsys.security.smartcard.model.app.CardAuthenticationException;
import de.intarsys.security.smartcard.module.common.CardModule;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CiCardProduct
extends CommonCardProduct {
    private static final Logger Log = LoggerFactory.getLogger(CiCardProduct.class);

    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        return true;
    }

    public void accepted(ICardProductFactory cardInfo, ICardConnection connection) throws CardApplicationException {
    }

    public boolean acceptFile(CiCardProductFactory ciCardProductFactory, ICardConnection connection, IElement elStatement) throws CardApplicationException {
        IFileSystemApplication fs = this.createCardApplication(connection, IFileSystemApplication.class);
        String id = elStatement.attributeValue("id", null);
        String condition = elStatement.attributeValue("condition", null);
        if ("present".equals(condition)) {
            return this.fileIsPresent(fs, id);
        }
        if ("absent".equals(condition)) {
            return !this.fileIsPresent(fs, id);
        }
        if ("contains".equals(condition)) {
            byte[] bytes;
            String value = elStatement.attributeValue("value", null);
            CardFileInfo info = this.fileGetCardFileInfo(fs, id);
            if (info == null || info.isDirectory()) {
                return false;
            }
            if (info.isTransparent()) {
                bytes = fs.readBinaryCached(info.getCardFile());
            } else {
                int index = ElementTools.getInt((IElement)elStatement, (String)"index", (int)-1);
                bytes = fs.readRecordCached(info.getCardFile(), index);
            }
            String hexBytes = HexTools.bytesToHexString((byte[])bytes);
            return Pattern.matches(value, hexBytes);
        }
        return false;
    }

    public boolean acceptProperty(ICardProductFactory factory, ICardConnection connection, String key, String value) throws CardApplicationException {
        if ("atr".equals(key)) {
            String atrString = connection.getCard().getAtr().print();
            return Pattern.matches(value, atrString);
        }
        return false;
    }

    @Override
    public void checkResponse(RequestAPDU req, ResponseAPDU resp) throws CardApplicationException {
        this.getCardOperatingSystem().checkResponse(req, resp);
    }

    @Override
    public <T extends ICardApplication> T createCardApplication(ICardConnection connection, Class<T> type) throws CardApplicationException {
        CardApplicationInfo info = (CardApplicationInfo)this.getCardInfo().lookupCardApplicationInfo(type);
        if (info == null) {
            throw new CardApplicationNotSupported(type);
        }
        this.updateCardApplicationInfo(connection, info);
        try {
            return (T)info.createCardApplication(connection, this);
        }
        catch (CardAuthenticationException e) {
            throw e;
        }
        catch (CardApplicationCardUnavailable e) {
            throw e;
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationException e) {
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace("Factory '" + info.getClass().getName() + "': " + e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected CiCardInfo createCardInfo() throws ObjectCreationException {
        CiCardInfo cardInfo = new CiCardInfo();
        cardInfo.setLabel(this.getId());
        return cardInfo;
    }

    protected CardApplicationBinding createDefaultBinding(ICardHolderCertificateInfo certInfo) {
        CardApplicationBinding binding = new CardApplicationBinding();
        binding.setCardHolderCertificateInfo(certInfo);
        return binding;
    }

    protected CardFileInfo fileGetCardFileInfo(IFileSystemApplication fileSystem, String id) throws CardApplicationException {
        CardFileInfo info = null;
        try {
            ICardFile cardFile = this.getCardInfo().getFileSystem().lookupFile(id);
            if (cardFile != null) {
                CardFileSelector selector = cardFile.asSelector();
                info = cardFile.isDirectory() ? fileSystem.selectDf(selector, true) : fileSystem.selectEf(selector, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    protected boolean fileIsPresent(IFileSystemApplication fileSystem, String id) throws CardApplicationException {
        return this.fileGetCardFileInfo(fileSystem, id) != null;
    }

    @Override
    public CiCardInfo getCardInfo() {
        return (CiCardInfo)super.getCardInfo();
    }

    @Override
    public ICardOperatingSystem getCardOperatingSystem() {
        return this.getFactory().getCardOperatingSystem();
    }

    @Override
    public CiCardProductFactory getFactory() {
        return (CiCardProductFactory)super.getFactory();
    }

    @Override
    public String getId() {
        return this.getFactory().getId();
    }

    @Override
    public String getIssuer() {
        return this.getFactory().getIssuer();
    }

    @Override
    public IMessageBundle getMessageBundle() {
        return this.getFactory().getMessageBundle();
    }

    @Override
    public CardModule getModule() {
        return this.getFactory().getModule();
    }

    @Override
    public String getName() {
        return this.getFactory().getName();
    }

    public final void initialize(ICardConnection connection) throws ObjectCreationException {
        CiCardInfo cardInfo = this.createCardInfo();
        this.setCardInfo(cardInfo);
        try {
            cardInfo.setMessageBundle(this.getFactory().getMessageBundle());
            this.initializeCardInfo(connection, cardInfo);
            if (cardInfo.getSupportsExtendedApdu() == null) {
                cardInfo.setSupportsExtendedApdu(false);
            }
            for (ICardApplicationInfo appInfo : cardInfo.getCardApplicationInfos()) {
                this.initializeCardInfoApplicationInfo(cardInfo, appInfo);
            }
        }
        catch (ConfigurationException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    protected void initializeCardInfo(ICardConnection connection, CiCardInfo cardInfo) throws ConfigurationException {
        new CiCardInfoConfigurationBuilder(this.getFactory().getCardInfoElement()).process(cardInfo);
    }

    protected void initializeCardInfoApplicationInfo(CiCardInfo cardInfo, ICardApplicationInfo appInfo) {
        if (appInfo.getBindings().isEmpty()) {
            this.initializeCardInfoApplicationInfoBindings(cardInfo, appInfo);
        }
    }

    protected void initializeCardInfoApplicationInfoBindings(CiCardInfo cardInfo, ICardApplicationInfo appInfo) {
        Collection<ICardHolderCertificateInfo> certInfos;
        Class clazz = appInfo.getCardApplicationType();
        if (cardInfo.getPkcs15Structure() == null) {
            certInfos = cardInfo.getCardHolderCertificateInfos();
        } else if (ISignApplication.class == clazz) {
            ArrayList<ICardHolderCertificateInfo> temp = new ArrayList<ICardHolderCertificateInfo>(2);
            temp.addAll(cardInfo.getPkcs15Structure().getCardHolderCertificateInfosQes());
            temp.addAll(cardInfo.getPkcs15Structure().getCardHolderCertificateInfosSignature());
            certInfos = temp;
        } else {
            certInfos = IQSignApplication.class == clazz ? cardInfo.getPkcs15Structure().getCardHolderCertificateInfosQes() : (IAdvSignApplication.class == clazz ? cardInfo.getPkcs15Structure().getCardHolderCertificateInfosSignature() : (IAuthenticateApplication.class == clazz ? cardInfo.getPkcs15Structure().getCardHolderCertificateInfosAuthentication() : (IDecryptApplication.class == clazz ? cardInfo.getPkcs15Structure().getCardHolderCertificateInfosEncryption() : cardInfo.getPkcs15Structure().getCardHolderCertificateInfos())));
        }
        for (ICardHolderCertificateInfo certInfo : certInfos) {
            appInfo.addBinding(this.createDefaultBinding(certInfo));
        }
    }

    protected void setBindings(CardApplicationInfo appInfo, List<CardApplicationBinding> bindings) {
        appInfo.setBindings(bindings);
    }

    public String toString() {
        return "product " + this.getFactory().toString();
    }

    protected void updateCardApplicationInfo(ICardConnection connection, CardApplicationInfo info) throws CardApplicationException {
    }
}

