/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.card.ATR;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiAtr;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.CiIdentification;
import de.intarsys.security.smartcard.model.CommonCardProductFactory;
import de.intarsys.security.smartcard.model.ICardOperatingSystem;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.module.common.CardFunction;
import de.intarsys.security.smartcard.module.common.CardModule;
import de.intarsys.security.smartcard.module.js.JSCodeExitHandler;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.codeexit.ICodeExitHandler;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageBundleFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanComponent(role="ICardProductFactory")
public class CiCardProductFactory
extends CommonCardProductFactory {
    private static final Logger Log = LoggerFactory.getLogger(CiCardProductFactory.class);
    private String cardInfoFile;
    private IMessageBundle messageBundle;
    private ICardOperatingSystem cardOperatingSystem;
    private IElement cardInfoElement;
    private IElement cardProductElement;
    private String issuer;
    private String name;
    private final Object lock = new Object();
    private CardModule module;
    private boolean initialized = false;
    private boolean failed = false;
    private CiIdentification identification;

    protected boolean accept(ICardConnection connection, CiCardProduct product) throws CardApplicationException {
        if (!this.acceptIdentification(connection, product, this.getIdentification())) {
            Log.trace(this.getLogPrefix() + " accept identification failed");
            return false;
        }
        return true;
    }

    protected boolean acceptAtr(ICardConnection connection, CiCardProduct product, CiAtr ciAtr, ATR atr) {
        int i;
        byte[] tempMask;
        byte[] tempRef;
        byte[] tempValue;
        if (ciAtr.getTsValue() != -1 && (atr.getTs() & ciAtr.getTsMask()) != (ciAtr.getTsValue() & ciAtr.getTsMask())) {
            Log.trace(this.getLogPrefix() + " accept atr ts failed");
            return false;
        }
        if (ciAtr.getT0Value() != -1 && (atr.getT0() & ciAtr.getT0Mask()) != (ciAtr.getT0Value() & ciAtr.getT0Mask())) {
            Log.trace(this.getLogPrefix() + " accept atr t0 failed");
            return false;
        }
        if (ciAtr.getInterfaceValue() != null) {
            tempValue = ciAtr.getInterfaceValue();
            tempRef = atr.getInterfaceBytes();
            tempMask = ciAtr.getInterfaceMask();
            if (tempMask == null) {
                tempMask = tempRef;
            }
            if (tempRef.length != tempValue.length || tempRef.length != tempMask.length) {
                Log.trace(this.getLogPrefix() + " accept atr interface failed");
                return false;
            }
            for (i = 0; i < tempRef.length; ++i) {
                if ((tempValue[i] & tempMask[i]) == (tempRef[i] & tempMask[i])) continue;
                Log.trace(this.getLogPrefix() + " accept atr interface failed");
                return false;
            }
        }
        if (ciAtr.getHistoricalValue() != null) {
            tempValue = ciAtr.getHistoricalValue();
            tempRef = atr.getHistoricalBytes();
            tempMask = ciAtr.getHistoricalMask();
            if (tempMask == null) {
                tempMask = tempRef;
            }
            if (tempRef.length != tempValue.length || tempRef.length != tempMask.length) {
                Log.trace(this.getLogPrefix() + " accept atr historical failed");
                return false;
            }
            for (i = 0; i < tempRef.length; ++i) {
                if ((tempValue[i] & tempMask[i]) == (tempRef[i] & tempMask[i])) continue;
                Log.trace(this.getLogPrefix() + " accept atr historical failed");
                return false;
            }
        }
        return true;
    }

    protected boolean acceptIdentification(ICardConnection connection, CiCardProduct product, CiIdentification ciIdentification) throws CardApplicationException {
        if (ciIdentification == null || ciIdentification.getScript() == null) {
            return true;
        }
        IElement elScript = ciIdentification.getScript();
        return this.acceptIdentificationOr(connection, product, elScript);
    }

    protected boolean acceptIdentificationAnd(ICardConnection connection, CiCardProduct product, IElement elScript) throws CardApplicationException {
        Iterator itStatement = elScript.elementIterator();
        while (itStatement.hasNext()) {
            IElement elStatement = (IElement)itStatement.next();
            if (this.acceptIdentificationStatement(connection, product, elStatement)) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptIdentificationAtr(ICardConnection connection, CiCardProduct product, IElement elAtr) {
        CiAtr atr = new CiAtr();
        atr.setStrHistoricalMask(ElementTools.getString((IElement)elAtr, (String)"historical-mask", null));
        atr.setStrHistoricalValue(ElementTools.getString((IElement)elAtr, (String)"historical-value", null));
        atr.setStrInterfaceMask(ElementTools.getString((IElement)elAtr, (String)"interface-mask", null));
        atr.setStrInterfaceValue(ElementTools.getString((IElement)elAtr, (String)"interface-value", null));
        atr.setStrT0Mask(ElementTools.getString((IElement)elAtr, (String)"t0-mask", null));
        atr.setStrT0Value(ElementTools.getString((IElement)elAtr, (String)"t0-value", null));
        atr.setStrTsMask(ElementTools.getString((IElement)elAtr, (String)"ts-mask", null));
        atr.setStrTsValue(ElementTools.getString((IElement)elAtr, (String)"ts-value", null));
        atr.init();
        return this.acceptAtr(connection, product, atr, connection.getCard().getAtr());
    }

    protected boolean acceptIdentificationFile(ICardConnection connection, CiCardProduct product, IElement elStatement) throws CardApplicationException {
        return product.acceptFile(this, connection, elStatement);
    }

    protected boolean acceptIdentificationNot(ICardConnection connection, CiCardProduct product, IElement elScript) throws CardApplicationException {
        return !this.acceptIdentificationOr(connection, product, elScript);
    }

    protected boolean acceptIdentificationOr(ICardConnection connection, CiCardProduct product, IElement elScript) throws CardApplicationException {
        Iterator itStatement = elScript.elementIterator();
        while (itStatement.hasNext()) {
            IElement elStatement = (IElement)itStatement.next();
            if (!this.acceptIdentificationStatement(connection, product, elStatement)) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptIdentificationProperty(ICardConnection connection, CiCardProduct product, IElement elProperty) throws CardApplicationException {
        String attrName = elProperty.attributeValue("name", null);
        String attrValue = elProperty.attributeValue("value", null);
        return product.acceptProperty(this, connection, attrName, attrValue);
    }

    protected boolean acceptIdentificationStatement(ICardConnection connection, CiCardProduct product, IElement elStatement) throws CardApplicationException {
        boolean result;
        if ("atr".equals(elStatement.getName())) {
            result = this.acceptIdentificationAtr(connection, product, elStatement);
            Log.trace(this.getLogPrefix() + " " + elStatement + " " + (result ? "accepted" : "denied") + " for " + connection.getCard().getAtr());
        } else if ("file".equals(elStatement.getName())) {
            result = this.acceptIdentificationFile(connection, product, elStatement);
            Log.trace(this.getLogPrefix() + " " + elStatement + " " + (result ? "accepted" : "denied"));
        } else if ("property".equals(elStatement.getName())) {
            result = this.acceptIdentificationProperty(connection, product, elStatement);
            Log.trace(this.getLogPrefix() + " " + elStatement + " " + (result ? "accepted" : "denied"));
        } else if ("and".equals(elStatement.getName())) {
            result = this.acceptIdentificationAnd(connection, product, elStatement);
        } else if ("or".equals(elStatement.getName())) {
            result = this.acceptIdentificationOr(connection, product, elStatement);
        } else if ("not".equals(elStatement.getName())) {
            result = this.acceptIdentificationNot(connection, product, elStatement);
        } else if ("true".equals(elStatement.getName())) {
            result = true;
        } else if ("false".equals(elStatement.getName())) {
            result = false;
        } else {
            throw new CardApplicationException("unknown identification statement " + elStatement.getName());
        }
        return result;
    }

    protected CiCardProduct basicCreate(ICardConnection connection) throws ObjectCreationException {
        CiCardProduct product = this.getCardProductElement() == null ? new CiCardProduct() : (CiCardProduct)ElementTools.createObject((IElement)this.getCardProductElement(), CiCardProduct.class, (Object)this.getContext(), (IArgs)Args.create());
        product.setFactory(this);
        product.setCard(connection.getCard());
        product.initialize(connection);
        return product;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setCardInfoFile(ElementTools.getString((IElement)element, (String)"cardInfoFile", (String)this.getCardInfoFile()));
    }

    @Override
    public ICardProduct create(ICardConnection connection) throws CardApplicationException {
        this.initialize();
        if (this.failed) {
            return null;
        }
        try {
            Log.trace(this.getLogPrefix() + " create test product");
            CiCardProduct product = this.basicCreate(connection);
            if (!this.accept(connection, product)) {
                Log.trace(this.getLogPrefix() + " accept failed");
                return null;
            }
            if (product.accept(this, connection)) {
                Log.trace(this.getLogPrefix() + " product accepted");
                product.accepted(this, connection);
                return product;
            }
            return null;
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationCardUnavailable e) {
            throw e;
        }
        catch (Exception e) {
            Log.warn(this.getLogPrefix() + " error creating product (" + ExceptionTools.getMessage((Throwable)e) + ")");
            return null;
        }
    }

    protected IElement getCardInfoElement() {
        return this.cardInfoElement;
    }

    public String getCardInfoFile() {
        return this.cardInfoFile;
    }

    public ICardOperatingSystem getCardOperatingSystem() {
        this.initialize();
        return this.cardOperatingSystem;
    }

    protected IElement getCardProductElement() {
        this.initialize();
        return this.cardProductElement;
    }

    public CiIdentification getIdentification() {
        return this.identification;
    }

    public String getIssuer() {
        this.initialize();
        return this.issuer;
    }

    @Override
    protected String getLogPrefix() {
        return "card product factory " + this.getId();
    }

    public IMessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    public CardModule getModule() {
        return this.module;
    }

    public String getName() {
        this.initialize();
        return this.name;
    }

    protected void init(IElement elCard) throws Exception {
        this.setId(ElementTools.getString((IElement)elCard, (String)"id", null));
        this.name = ElementTools.getString((IElement)elCard, (String)"name", null);
        this.issuer = ElementTools.getString((IElement)elCard, (String)"issuer", null);
        IElement elOperatingSystem = ElementTools.getElement((IElement)elCard, (String)"operatingSystem");
        if (elOperatingSystem != null) {
            this.cardOperatingSystem = (ICardOperatingSystem)ElementTools.createObject((IElement)elOperatingSystem, ICardOperatingSystem.class, (Object)this.getContext(), (IArgs)Args.create());
        }
        this.cardProductElement = ElementTools.getElement((IElement)elCard, (String)"product");
        this.module = this.initModule(elCard);
        this.identification = this.initIdentification(elCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initialize() {
        Object object = this.lock;
        // MONITORENTER : object
        if (this.initialized) {
            // MONITOREXIT : object
            return;
        }
        this.initialized = true;
        this.messageBundle = this.initMessageBundle();
        if (StringTools.isEmpty((String)this.getCardInfoFile())) {
            this.failed = true;
            Log.info(this.getLogPrefix() + " no card info file defined");
            return;
        }
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(this.getCardInfoFile());
            this.cardInfoElement = ElementFactory.get().parse(is).getRootElement();
            this.init(this.cardInfoElement);
        }
        catch (Exception e) {
            try {
                this.failed = true;
                Log.warn("ICardProductFactory error interpreting '" + this.getCardInfoFile() + "': " + e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                throw throwable;
            }
            StreamTools.close((Closeable)is);
            return;
        }
        StreamTools.close((Closeable)is);
        return;
    }

    protected CiIdentification initIdentification(IElement elCard) {
        CiIdentification result = new CiIdentification();
        IElement elObject = elCard.element("identification");
        result.setScript(elObject);
        return result;
    }

    protected IMessageBundle initMessageBundle() {
        String path = PathTools.getParent((String)this.getCardInfoFile(), (String)"");
        path = path.replace("/", ".");
        if ((path = path.replace("\\", ".")).startsWith(".")) {
            path = path.substring(1);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return MessageBundleFactory.get().getMessageBundle(path + ".messages", classLoader);
    }

    protected CardModule initModule(IElement elCard) throws ObjectCreationException {
        IElement elModule = elCard.element("module");
        CardModule result = new CardModule();
        if (elModule != null) {
            Iterator itFunctions = elModule.elementIterator("function");
            while (itFunctions.hasNext()) {
                IElement elFunction = (IElement)itFunctions.next();
                CardFunction function = new CardFunction();
                function.setName(elFunction.attributeValue("name", "anonymous"));
                CodeExit codeExit = CodeExit.createFromElement((IElement)elFunction);
                codeExit.setHandler((ICodeExitHandler)new JSCodeExitHandler());
                function.setDelegate((IFunctor)codeExit);
                result.addFunction(function);
            }
        }
        return result;
    }

    public void setCardInfoFile(String cardInfoFile) {
        this.cardInfoFile = cardInfoFile;
    }

    public String toString() {
        return this.getCardInfoFile();
    }
}

