/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.CiAccess;
import de.intarsys.security.smartcard.model.ICardFile;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CiFile
implements ICardFile {
    private final List<CiAccess> accessList = new ArrayList<CiAccess>();
    private String fileId;
    private String fileName;
    private String id = "";
    private String label;
    private CiFile parent;
    private String description;
    private String content;
    private List<CiFile> files;

    public void addFile(CiFile file) {
        if (this.files == null) {
            this.files = new ArrayList<CiFile>();
        }
        this.files.add(file);
        file.setParent(this);
    }

    @Override
    public CardFileSelector asSelector() {
        if (this.getFileName() != null) {
            return new CardFileName(HexTools.hexStringToBytes((String)this.getFileName()));
        }
        if (this.getParent() != null && !this.getParent().isRoot()) {
            return this.getParent().asSelector().resolve(new CardFilePath(this.getFileId()));
        }
        return new CardFilePath(this.getFileId());
    }

    protected CiFile findFile(String segment) {
        if (this.files == null) {
            return null;
        }
        for (CiFile file : this.files) {
            if (!segment.equals(file.getId())) continue;
            return file;
        }
        for (CiFile file : this.files) {
            CiFile tempFile = file.findFile(segment);
            if (tempFile == null) continue;
            return tempFile;
        }
        return null;
    }

    public List<CiAccess> getAccessList() {
        return this.accessList;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public List<ICardFile> getFiles() {
        if (this.files == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ICardFile>(this.files);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIdPath() {
        if (this.getParent() != null && !this.getParent().isRoot()) {
            return this.getParent().getIdPath() + "/" + this.id;
        }
        return this.id;
    }

    @Override
    public String getLabel() {
        if (StringTools.isEmpty((String)this.label)) {
            return this.getId();
        }
        return this.label;
    }

    public CiFile getParent() {
        return this.parent;
    }

    @Override
    public boolean isDirectory() {
        return this.files != null;
    }

    public boolean isRoot() {
        return StringTools.isEmpty((String)this.id);
    }

    public boolean removeFile(CiFile file) {
        if (this.files == null) {
            return false;
        }
        file.setParent(null);
        return this.files.remove(file);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileId(String path) {
        this.fileId = path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFiles(List<CiFile> files) {
        this.files = files;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParent(CiFile parent) {
        this.parent = parent;
    }
}

