/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.cmd.ISOCommandSet;
import de.intarsys.security.smartcard.model.CardResponseHandler;
import de.intarsys.security.smartcard.model.ICardOperatingSystem;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.PACKAGE;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.IMessageBundle;

public abstract class CommonCardOperatingSystem
implements ICardOperatingSystem,
IElementConfigurable {
    private static CardResponseHandler cardResponseHandler = new CardResponseHandler();
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String manufacturer = null;
    private String id;
    private final ISOCommandSet commandSet = this.createCommandSet();

    protected CommonCardOperatingSystem() {
    }

    @Override
    public void checkResponse(RequestAPDU req, ResponseAPDU resp) throws CardApplicationException {
        cardResponseHandler.checkResponse(req, resp);
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setId(ElementTools.getString((IElement)element, (String)"id", (String)this.getId()));
        this.setManufacturer(ElementTools.getString((IElement)element, (String)"manufacturer", (String)this.getManufacturer()));
    }

    protected abstract ISOCommandSet createCommandSet();

    @Override
    public <T extends ICommand> T getCommand(Class<T> command) {
        return this.getCommandSet().getCommand(command);
    }

    protected ISOCommandSet getCommandSet() {
        return this.commandSet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    static {
        cardResponseHandler.addResponseMap("*", "*", "*", CardStatusCodeException.class, "unknown exception");
        cardResponseHandler.addResponseMap("b0", "62", "81", null, null);
        cardResponseHandler.addResponseMap("b0", "62", "82", null, null);
        cardResponseHandler.addResponseMap("b2", "62", "81", null, null);
        cardResponseHandler.addResponseMap("b2", "62", "82", null, null);
        cardResponseHandler.addResponseMap("*", "63", "0", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "63", "C*", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "0", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "1", CardAuthenticationCanceledException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "2", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "3", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "4", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "65", "0", CardStatusCodeException.class, "no information given");
        cardResponseHandler.addResponseMap("*", "65", "81", CardStatusCodeException.class, "memory failure (unsuccessful change)");
        cardResponseHandler.addResponseMap("*", "66", "0", CardStatusCodeException.class, "the environment cannot be set or modified (no further information)");
        cardResponseHandler.addResponseMap("*", "67", "0", CardStatusCodeException.class, "wrong length (no Le field)");
        cardResponseHandler.addResponseMap("*", "68", "0", CardStatusCodeException.class, "no information given");
        cardResponseHandler.addResponseMap("*", "68", "81", CardStatusCodeException.class, "logical channel not supported");
        cardResponseHandler.addResponseMap("*", "68", "82", CardStatusCodeException.class, "secure messaging not supported");
        cardResponseHandler.addResponseMap("*", "68", "83", CardStatusCodeException.class, "final chained command expected");
        cardResponseHandler.addResponseMap("*", "68", "84", CardStatusCodeException.class, "command chaining not supported");
        cardResponseHandler.addResponseMap("*", "69", "0", CardStatusCodeException.class, "no information given");
        cardResponseHandler.addResponseMap("*", "69", "81", CardStatusCodeException.class, "command incompatible with file structure");
        cardResponseHandler.addResponseMap("*", "69", "82", CardAuthenticationFailedException.class, "security status not satisfied");
        cardResponseHandler.addResponseMap("*", "69", "83", CardAuthenticationFailedException.class, "authentication method blocked");
        cardResponseHandler.addResponseMap("*", "69", "84", CardAuthenticationFailedException.class, "referenced data invalidated");
        cardResponseHandler.addResponseMap("20", "69", "85", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "69", "85", CardStatusCodeException.class, Msg.getString("CommonCardOperatingSystem.6985", new Object[0]));
        cardResponseHandler.addResponseMap("*", "69", "86", CardStatusCodeException.class, "command not allowed (no current EF)");
        cardResponseHandler.addResponseMap("*", "69", "87", CardStatusCodeException.class, "expected secure messaging data objects missing");
        cardResponseHandler.addResponseMap("*", "69", "88", CardStatusCodeException.class, "incorrect secure messaging data objects");
        cardResponseHandler.addResponseMap("*", "6A", "0", CardStatusCodeException.class, "no information given");
        cardResponseHandler.addResponseMap("*", "6A", "80", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "6A", "81", CardStatusCodeException.class, "function not supported");
        cardResponseHandler.addResponseMap("*", "6A", "82", CardFileNotFoundException.class, "");
        cardResponseHandler.addResponseMap("*", "6A", "83", CardStatusCodeException.class, "record not found");
        cardResponseHandler.addResponseMap("*", "6A", "84", CardStatusCodeException.class, "not enough memory space in the file");
        cardResponseHandler.addResponseMap("*", "6A", "85", CardStatusCodeException.class, "Lc inconsistent with TLV structure");
        cardResponseHandler.addResponseMap("*", "6A", "86", CardStatusCodeException.class, "incorrect parameters P1-P2");
        cardResponseHandler.addResponseMap("*", "6A", "87", CardStatusCodeException.class, "wrong length of the data in the data field");
        cardResponseHandler.addResponseMap("20", "6A", "87", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("24", "6A", "87", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("2c", "6A", "87", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "6A", "88", CardStatusCodeException.class, "referenced data not found");
        cardResponseHandler.addResponseMap("*", "6A", "89", CardStatusCodeException.class, "file already exists");
        cardResponseHandler.addResponseMap("*", "6A", "8A", CardStatusCodeException.class, "DF name already exists");
        cardResponseHandler.addResponseMap("*", "6B", "0", CardStatusCodeException.class, "wrong parameters (offset outside the EF)");
        cardResponseHandler.addResponseMap("*", "6C", "*", CardStatusCodeException.class, "wrong length");
        cardResponseHandler.addResponseMap("*", "6D", "*", CardStatusCodeException.class, "instruction code not supported or invalid");
        cardResponseHandler.addResponseMap("*", "6E", "*", CardStatusCodeException.class, "class not supported");
        cardResponseHandler.addResponseMap("*", "6F", "*", CardStatusCodeException.class, "no precise diagnosis");
        cardResponseHandler.addResponseMap("*", "90", "*", null, null);
        cardResponseHandler.addResponseMap("*", "90", "0", null, null);
    }
}

