/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardHolderCertificate;
import de.intarsys.security.smartcard.model.CommonCardProductFactory;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.PACKAGE;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;

public abstract class CommonCardProduct
implements ICardProduct,
IElementConfigurable,
IInitializeable,
IMessageBundleSupport {
    private static final Attribute ATTR_QSIG_RESTRICTION = new Attribute("qSigRestriction");
    private static final Attribute ATTR_GLOBAL_RESTRICTION = new Attribute("globalRestriction");
    private CommonCardProductFactory factory;
    private ICard card;
    private ICardInfo cardInfo;

    protected CommonCardProduct() {
    }

    @Override
    public boolean acceptCardHolderCertificate(CardHolderCertificate cert) {
        return true;
    }

    public void configure(IElement element) throws ConfigurationException {
    }

    protected int createGlobalRestriction(ICardConnection connection) throws CardApplicationException {
        return -1;
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        return 1;
    }

    protected int createRestriction(Class<? extends ICardApplication> type, ICardConnection connection) throws CardApplicationException {
        return 1;
    }

    @Override
    public ICard getCard() {
        return this.card;
    }

    @Override
    public ICardInfo getCardInfo() {
        return this.cardInfo;
    }

    public CommonCardProductFactory getFactory() {
        return this.factory;
    }

    @Override
    public final int getGlobalRestriction(ICardConnection connection) throws CardApplicationException {
        ICard tmpCard = connection.getCard();
        Integer result = (Integer)tmpCard.getAttribute((Object)ATTR_GLOBAL_RESTRICTION);
        if (result == null) {
            result = this.createGlobalRestriction(connection);
            tmpCard.setAttribute((Object)ATTR_GLOBAL_RESTRICTION, (Object)result);
        }
        return result;
    }

    protected String getLogPrefix() {
        return this.factory.getLogPrefix();
    }

    public IMessageBundle getMessageBundle() {
        return PACKAGE.Messages;
    }

    @Override
    public final int getQSigRestriction(ICardConnection connection) throws CardApplicationException {
        ICard tmpCard = connection.getCard();
        Integer result = (Integer)tmpCard.getAttribute((Object)ATTR_QSIG_RESTRICTION);
        if (result == null) {
            result = this.createQSigRestriction(connection);
            tmpCard.setAttribute((Object)ATTR_QSIG_RESTRICTION, (Object)result);
        }
        return result;
    }

    @Override
    public final int getRestriction(Class<? extends ICardApplication> type, ICardConnection connection) throws CardApplicationException {
        ICard tmpCard = connection.getCard();
        Integer result = (Integer)tmpCard.getAttribute((Object)ATTR_QSIG_RESTRICTION);
        if (result == null) {
            result = this.createRestriction(type, connection);
            tmpCard.setAttribute((Object)ATTR_QSIG_RESTRICTION, (Object)result);
        }
        return result;
    }

    @Override
    public boolean hasRoot() {
        return true;
    }

    public void initializeAfterConstruction() {
    }

    public void initializeAfterCreation() {
    }

    public void setCard(ICard card) {
        this.card = card;
    }

    public void setCardInfo(ICardInfo cardInfo) {
        this.cardInfo = cardInfo;
    }

    public void setFactory(CommonCardProductFactory factory) {
        this.factory = factory;
    }
}

