/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.smartcard.model.IMechanism;
import java.util.ArrayList;
import java.util.List;

public class Mechanism
implements IMechanism {
    private String id;
    private String operation;
    private String algorithmId;
    private int algorithmRef = -1;
    private String outputEncodingAlgorithmName;
    private String inputEncodingAlgorithmName;
    private List<String> hashAlgorithmNames = new ArrayList<String>();
    private int securityEnvironment = -1;

    public Mechanism() {
    }

    public Mechanism(String id) {
        this.id = id;
    }

    @Override
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    @Override
    public int getAlgorithmRef() {
        return this.algorithmRef;
    }

    @Override
    public List<String> getHashAlgorithmNames() {
        return this.hashAlgorithmNames;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInputEncodingAlgorithmName() {
        return this.inputEncodingAlgorithmName;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getOutputEncodingAlgorithmName() {
        return this.outputEncodingAlgorithmName;
    }

    @Override
    public int getSecurityEnvironment() {
        return this.securityEnvironment;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public void setAlgorithmRef(int algorithmRef) {
        this.algorithmRef = algorithmRef;
    }

    public void setHashAlgorithmNames(List<String> hashAlgorithmNames) {
        this.hashAlgorithmNames = hashAlgorithmNames;
    }

    public void setHashAlgorithmNames(String hashAlgorithmNames) {
        this.hashAlgorithmNames = DigestAlgorithm.toList((String)hashAlgorithmNames);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInputEncodingAlgorithmName(String transformation) {
        this.inputEncodingAlgorithmName = transformation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setOutputEncodingAlgorithmName(String encoding) {
        this.outputEncodingAlgorithmName = encoding;
    }

    public void setSecurityEnvironment(int securityEnvironment) {
        this.securityEnvironment = securityEnvironment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mechanism ");
        sb.append(this.getId());
        sb.append(", operation=");
        sb.append(this.getOperation());
        sb.append(", algorithmRef=");
        sb.append(this.getAlgorithmRef());
        sb.append(", algorithmId=");
        sb.append(this.getAlgorithmId());
        sb.append(", hashAlgorithms=");
        sb.append(this.getHashAlgorithmNames());
        sb.append(", inputEncoding=");
        sb.append(this.getInputEncodingAlgorithmName());
        sb.append(", outputEncoding=");
        sb.append(this.getOutputEncodingAlgorithmName());
        return sb.toString();
    }
}

