/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PACKAGE;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.LiteralMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PinInfo
implements IPinInfo {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final IPinCodec pinCodec;
    private CardFileSelector directory;
    private IMessage label;
    private boolean fixed;
    private boolean resetPinInfo = false;
    private final String id;
    private int referenceId;
    private int transportLength = -1;
    private IPinInfo resettingPinInfo;
    private String transportLabel;
    private char[] transportValue;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean hidden = false;
    private boolean resetRetryCounterOnly;

    public static PinInfo createResetPinInfo(IPinInfo pinInfo, String id, int reference, IPinCodec pinCodec, CardFileSelector path, boolean resetRetryCounterOnly) {
        PinInfo rp = new PinInfo(id, reference, pinCodec, path);
        rp.setResetPinInfo(true);
        rp.setResetRetryCounterOnly(resetRetryCounterOnly);
        ((PinInfo)pinInfo).setResettingPinInfo(rp);
        return rp;
    }

    public PinInfo(String id, int referenceId, IPinCodec pinCodec, CardFileSelector pDirectory) {
        this.directory = pDirectory;
        this.referenceId = referenceId;
        this.pinCodec = pinCodec;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof IPinInfo) {
            IPinInfo other = (IPinInfo)obj;
            return this.referenceId == other.getReference() && this.directory.equals(other.getDirectory());
        }
        return false;
    }

    @Override
    public CardFileSelector getDirectory() {
        return this.directory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label == null ? null : this.label.getString();
    }

    @Override
    public IPinCodec getPinCodec() {
        return this.pinCodec;
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public int getReference() {
        return this.referenceId;
    }

    @Override
    public IPinInfo getResettingPinInfo() {
        return this.resettingPinInfo;
    }

    @Override
    public String getTransportLabel() {
        if (this.transportLabel == null) {
            return Msg.getString("PinInfo.PIN.Transport.label", new Object[0]);
        }
        return this.transportLabel;
    }

    @Override
    public int getTransportLength() {
        return this.transportLength;
    }

    @Override
    public char[] getTransportValue() {
        return this.transportValue;
    }

    public int hashCode() {
        return this.referenceId + this.directory.hashCode();
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isResetPinInfo() {
        return this.resetPinInfo;
    }

    @Override
    public boolean isResetRetryCounterOnly() {
        return this.resetRetryCounterOnly;
    }

    @Override
    public String lookupProperty(String name) {
        return this.properties.get(name);
    }

    public void setDirectory(CardFileSelector directory) {
        this.directory = directory;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setLabel(Object value) {
        this.label = value == null ? null : (value instanceof IMessage ? (IMessage)value : LiteralMessage.create((String)String.valueOf(value)));
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    protected void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setReference(int referenceId) {
        this.referenceId = referenceId;
    }

    public void setResetPinInfo(boolean resetPinInfo) {
        this.resetPinInfo = resetPinInfo;
    }

    public void setResetRetryCounterOnly(boolean resetRetryCounterOnly) {
        this.resetRetryCounterOnly = resetRetryCounterOnly;
    }

    public void setResettingPinInfo(IPinInfo resetPinInfo) {
        this.resettingPinInfo = resetPinInfo;
    }

    public void setTransportLabel(String transportLabel) {
        this.transportLabel = transportLabel;
    }

    public void setTransportLength(int transportLength) {
        this.transportLength = transportLength;
    }

    public void setTransportValue(char[] transportValue) {
        this.transportValue = transportValue;
    }

    public String toString() {
        return this.getId() + "@" + this.getDirectory() + ":" + this.getLabel();
    }
}

