/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;

public class PinView {
    private final IPinInfo pinInfo;
    private final PinState pinState;
    private final PinState resettingPinState;
    private IMessageBundle messageBundle;

    public PinView(IPinInfo pinInfo, PinState pinState, PinState resettingPinState) {
        this.pinInfo = pinInfo;
        this.pinState = pinState;
        this.resettingPinState = resettingPinState;
    }

    public IMessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    public IPinInfo getPinInfo() {
        return this.pinInfo;
    }

    public PinState getPinState() {
        return this.pinState;
    }

    public IPinInfo getResettingPinInfo() {
        return this.pinInfo.getResettingPinInfo();
    }

    public PinState getResettingPinState() {
        return this.resettingPinState;
    }

    public boolean isChangeable() {
        if (this.pinInfo.isFixed()) {
            return false;
        }
        return this.pinState != null && this.pinState.isChangeable();
    }

    public boolean isChangeable(String context) {
        if (StringTools.isEmpty((String)context)) {
            return this.isChangeable();
        }
        String property = this.pinInfo.lookupProperty("changeable." + context);
        if (StringTools.isEmpty((String)property)) {
            return !this.pinInfo.isFixed() && this.pinState != null && this.pinState.isChangeable();
        }
        return Boolean.parseBoolean(property);
    }

    public boolean isInitializable() {
        if (this.pinInfo.isFixed()) {
            return false;
        }
        return this.pinState != null && this.pinState.isInitializable();
    }

    public boolean isInitializable(String context) {
        if (StringTools.isEmpty((String)context)) {
            return this.isInitializable();
        }
        String property = this.pinInfo.lookupProperty("initializable." + context);
        if (StringTools.isEmpty((String)property)) {
            return !this.pinInfo.isFixed() && this.pinState != null && this.pinState.isInitializable();
        }
        return Boolean.parseBoolean(property);
    }

    public boolean isResettable() {
        return this.pinState != null && this.pinState.isResettable() && this.resettingPinState != null && this.resettingPinState.isVerifiable();
    }

    public boolean isResettable(String context) {
        if (StringTools.isEmpty((String)context)) {
            return this.isResettable();
        }
        String property = this.pinInfo.lookupProperty("resettable." + context);
        if (StringTools.isEmpty((String)property)) {
            return this.pinState != null && this.pinState.isResettable() && this.resettingPinState != null && this.resettingPinState.isVerifiable();
        }
        return Boolean.parseBoolean(property);
    }

    public boolean isVerifiable() {
        return this.pinState != null && this.pinState.isVerifiable();
    }

    public boolean isVerifiable(String context) {
        if (StringTools.isEmpty((String)context)) {
            return this.isVerifiable();
        }
        String property = this.pinInfo.lookupProperty("verifiable." + context);
        if (StringTools.isEmpty((String)property)) {
            return this.pinState != null && this.pinState.isVerifiable();
        }
        return Boolean.parseBoolean(property);
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }
}

