/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPrivateKeyInfo;
import java.util.ArrayList;
import java.util.List;

public class PrivateKeyInfo
implements IPrivateKeyInfo {
    private final CardFileSelector directory;
    private final byte[] reference;
    private final String id;
    private final String encryptionAlgorithmName;
    private final List<IMechanism> mechanisms;

    public PrivateKeyInfo(String name, CardFileSelector pDirectory, byte[] reference, String encryptionAlgorithmName, List<IMechanism> mechanisms) {
        this.id = name;
        this.directory = pDirectory;
        this.reference = reference;
        this.encryptionAlgorithmName = encryptionAlgorithmName;
        this.mechanisms = mechanisms;
    }

    @Override
    public CardFileSelector getDirectory() {
        return this.directory;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IMechanism> getMechanisms() {
        return new ArrayList<IMechanism>(this.mechanisms);
    }

    @Override
    public byte[] getReference() {
        return this.reference;
    }

    @Override
    public IMechanism lookupMechanism(String mechanismId) {
        for (IMechanism mechanism : this.mechanisms) {
            if (!mechanismId.equals(mechanism.getId())) continue;
            return mechanism;
        }
        return null;
    }

    @Override
    public PrivateKeyInfo relocate(CardFileSelector dir) {
        return new PrivateKeyInfo(this.getId(), dir, this.getReference(), this.getEncryptionAlgorithmName(), this.mechanisms);
    }
}

