/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.ConnectionState;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class AbstractCardApplication
implements ICardApplication,
IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger(AbstractCardApplication.class);
    private String authenticationPrompt;
    private ICardProduct cardProduct;
    private ICardConnection cardConnection;
    private ConnectionState connectionState;
    private IElement configuration;
    private Secret authenticationPin;

    @Override
    public void authenticate() throws CardApplicationException {
    }

    protected void basicReset() throws CardApplicationException {
    }

    public void configure(IElement element) throws ConfigurationException {
        this.configuration = element;
    }

    protected Secret getAuthenticationPin() {
        return this.authenticationPin;
    }

    public String getAuthenticationPrompt() {
        return this.authenticationPrompt;
    }

    @Override
    public final ICard getCard() {
        return this.getCardConnection().getCard();
    }

    @Override
    public ICardConnection getCardConnection() {
        return this.cardConnection;
    }

    public final ICardInfo getCardInfo() {
        return this.getCardProduct().getCardInfo();
    }

    @Override
    public ICardProduct getCardProduct() {
        return this.cardProduct;
    }

    protected ICardTransmitter getCardTransmitter() {
        return this.connectionState.getCardTransmitter();
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    protected ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public IPasswordProvider getPasswordProvider() {
        return this.getConnectionState().getPasswordProvider();
    }

    @Override
    public boolean isDisableSPE() {
        return this.connectionState.isDisableSPE();
    }

    @Override
    public boolean isEnforceSPE() {
        return this.connectionState.isEnforceSPE();
    }

    @Override
    public boolean isSupportedSPE() {
        return !this.isDisableSPE();
    }

    @Override
    public boolean isValid() {
        return this.getCardConnection().isValid();
    }

    @Override
    public final void reset() throws CardApplicationException {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace(this + " reset card");
        }
        this.basicReset();
    }

    @Override
    public void setAuthenticationPin(Secret pin) {
        this.authenticationPin = pin;
    }

    @Override
    public void setAuthenticationPrompt(String msg) {
        this.authenticationPrompt = msg;
    }

    public void setCardConnection(ICardConnection cardConnection) {
        this.cardConnection = cardConnection;
        this.connectionState = ConnectionState.create(cardConnection);
    }

    public void setCardProduct(ICardProduct cardProduct) {
        this.cardProduct = cardProduct;
    }

    public void setCardTransmitter(ICardTransmitter cardTransmitter) {
        this.connectionState.setCardTransmitter(cardTransmitter);
    }

    @Override
    public void setDisableSPE(boolean enableSPE) {
        this.connectionState.setDisableSPE(enableSPE);
    }

    @Override
    public void setEnforceSPE(boolean enforceSPE) {
        this.connectionState.setEnforceSPE(enforceSPE);
    }

    @Override
    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.connectionState.setPasswordProvider(passwordProvider);
    }
}

