/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.card.ActiveCardConnectionMonitor;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveCardApplicationMonitor
extends ActiveCardConnectionMonitor {
    private static final Logger Log = LoggerFactory.getLogger(ActiveCardApplicationMonitor.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final Class<? extends ICardApplication> cardApplicationType;
    private ICardApplication activeCardApplication;

    public ActiveCardApplicationMonitor(ICardSystem cardSystem, Class<? extends ICardApplication> cardApplicationType) {
        super(cardSystem);
        if (cardApplicationType == null) {
            throw new NullPointerException("card application type can't be null");
        }
        this.cardApplicationType = cardApplicationType;
    }

    protected void acceptConnection(ICardConnection connection) throws Exception {
        Log.trace("{} create product and application", this.getLogPrefix());
        ICardProduct product = CardProductTools.getCardProduct(connection);
        try {
            this.activeCardApplication = product.createCardApplication(connection, this.getCardApplicationType());
            Log.trace("{} {} connected", this.getLogPrefix(), (Object)this.activeCardApplication);
            this.setActiveCardStateMessage(this.getCardConnectedMessage());
        }
        catch (Exception e) {
            Log.trace("{} application {} not found", this.getLogPrefix(), (Object)this.getCardApplicationType().getName());
            this.setActiveCardStateMessage(this.getCardNoApplicationMessage());
            try {
                connection.close(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        super.acceptConnection(connection);
    }

    protected State createState() {
        return new State(Arrays.asList(this.getCardSystem().getCardTerminals()), this.getActiveCardTerminal(), this.getActiveCardStateMessage(), this.getActiveCardApplication());
    }

    protected ICardApplication getActiveCardApplication() {
        return this.activeCardApplication;
    }

    public Class<? extends ICardApplication> getCardApplicationType() {
        return this.cardApplicationType;
    }

    protected String getCardNoApplicationMessage() {
        return Msg.getString("CardApplicationMonitor.noApplication", new Object[0]);
    }

    public State getState() {
        return (State)super.getState();
    }

    protected void resetConnection() {
        super.resetConnection();
        this.activeCardApplication = null;
    }

    protected void setActiveCardApplication(ICardApplication activeCardApplication) {
        this.activeCardApplication = activeCardApplication;
    }

    public static class State
    extends ActiveCardConnectionMonitor.State {
        private final ICardApplication activeCardApplication;

        public State(List<ICardTerminal> cardTerminals, ICardTerminal activeCardTerminal, String cardStateMessage, ICardApplication app) {
            super(cardTerminals, activeCardTerminal, app == null ? null : app.getCardConnection(), cardStateMessage);
            this.activeCardApplication = app;
        }

        public ICardApplication getActiveCardApplication() {
            return this.activeCardApplication;
        }
    }
}

